/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.utility;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class Utility {
    public static String toHexString(byte[] bytes) {
        return Utility.toHexString(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int start, int byteCount) {
        if (bytes != null && bytes.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = start;
            while (i < byteCount) {
                String hexString = Integer.toHexString(bytes[i] & 0xFF);
                if (hexString.length() == 1) {
                    buffer.append('0');
                }
                buffer.append(hexString);
                if (i < bytes.length - 1) {
                    buffer.append(' ');
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    public static byte[] getBinary(Context context, int id) {
        Resources resource = context.getResources();
        InputStream in = resource.openRawResource(id);
        BufferedInputStream bis = new BufferedInputStream(in);
        int bufferLength = 0;
        try {
            bufferLength = bis.available();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        byte[] buffer = new byte[bufferLength];
        int read = 0;
        try {
            read = bis.read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (read > 0) {
            return buffer;
        }
        return null;
    }

    public static byte[] getBinary(Context context, String fileName) {
        AssetManager assetManager = context.getAssets();
        InputStream in = null;
        try {
            in = assetManager.open(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(in);
        int bufferLength = 0;
        try {
            bufferLength = bis.available();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                bis.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                in.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return null;
        }
        byte[] buffer = new byte[bufferLength];
        int read = 0;
        try {
            try {
                read = bis.read(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    bis.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return null;
            }
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                in.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (read > 0) {
            return buffer;
        }
        return null;
    }

    public static byte[] copyOfRange(byte[] original, int start, int end) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        if (original == null) {
            throw new NullPointerException();
        }
        if (start < 0 || start > original.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (start > end) {
            throw new IllegalArgumentException();
        }
        byte[] newArray = new byte[end - start];
        int i = start;
        while (i < end) {
            newArray[i - start] = original[i];
            ++i;
        }
        return newArray;
    }

    public static int linearSearch(byte[] array, byte[] value) {
        if (array == null || value == null || array.length == 0 || value.length == 0 || array.length < value.length) {
            return -1;
        }
        int index = 0;
        while (index < array.length) {
            if (value[0] == array[index]) {
                int i = 0;
                while (i < value.length && value[i] == array[index + i]) {
                    ++i;
                }
                if (i == value.length) {
                    return index;
                }
            }
            ++index;
        }
        return -1;
    }
}

