/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.service;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.metapace.thermalprinter.MetapacePrinter;
import com.metapace.thermalprinter.service.ServiceManager;
import com.metapace.thermalprinter.utility.Command;
import com.metapace.thermalprinter.utility.Utility;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

public final class PrinterHandler
extends Handler {
    private static final String TAG = "PrinterHandler";
    private static final boolean D = MetapacePrinter.D;
    private ServiceManager mServiceManager;
    private Handler mApplicationHandler;
    private int mCurrentProcess;
    private int mStatus;
    private final byte[] NORMAL_STATUS;
    private byte[] mAutoStatusBack;
    private static final int RECEIVE_BUFFER_CAPACITY = 1024;
    private ByteBuffer mReceiveBuffer;
    private ByteBuffer readDataBuf;

    public PrinterHandler(ServiceManager serviceManager, Handler applicationHandler) {
        byte[] byArray = new byte[4];
        byArray[0] = 16;
        byArray[3] = 15;
        this.NORMAL_STATUS = byArray;
        this.mAutoStatusBack = new byte[4];
        this.readDataBuf = ByteBuffer.allocate(4);
        this.mServiceManager = serviceManager;
        this.mApplicationHandler = applicationHandler;
        this.mCurrentProcess = 0;
        int i = 0;
        while (i < this.mAutoStatusBack.length) {
            this.mAutoStatusBack[i] = this.NORMAL_STATUS[i];
            ++i;
        }
        this.mReceiveBuffer = ByteBuffer.allocate(1024);
    }

    public PrinterHandler(ServiceManager serviceManager, Handler applicationHandler, Looper looper) {
        super(looper);
        byte[] byArray = new byte[4];
        byArray[0] = 16;
        byArray[3] = 15;
        this.NORMAL_STATUS = byArray;
        this.mAutoStatusBack = new byte[4];
        this.readDataBuf = ByteBuffer.allocate(4);
        this.mServiceManager = serviceManager;
        this.mApplicationHandler = applicationHandler;
        this.mCurrentProcess = 0;
        int i = 0;
        while (i < this.mAutoStatusBack.length) {
            this.mAutoStatusBack[i] = this.NORMAL_STATUS[i];
            ++i;
        }
        this.mReceiveBuffer = ByteBuffer.allocate(1024);
    }

    int getCurrentProcess() {
        return this.mCurrentProcess;
    }

    void setCurrentProcess(int process) {
        this.mCurrentProcess = process;
        this.mReceiveBuffer.clear();
    }

    void initialize() {
        this.mCurrentProcess = 0;
        int i = 0;
        while (i < this.mAutoStatusBack.length) {
            this.mAutoStatusBack[i] = this.NORMAL_STATUS[i];
            ++i;
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (D) {
                    Log.d((String)TAG, (String)("MESSAGE_STATE_CHANGE: " + msg.arg1));
                }
                if (msg.arg1 == 2) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.mServiceManager.executeCommand(22, Command.PRINTER_ID_PRINTER_MODEL);
                    break;
                }
                this.mApplicationHandler.obtainMessage(msg.what, msg.arg1, msg.arg2, (Object)this.mServiceManager.getPrinterObjectHashCode()).sendToTarget();
                break;
            }
            case 3: {
                if (this.mCurrentProcess != 21) break;
                this.mCurrentProcess = 0;
                this.mApplicationHandler.obtainMessage(3, 21, -1, (Object)this.mServiceManager.getPrinterObjectHashCode()).sendToTarget();
                break;
            }
            case 2: {
                boolean isAutoStatusBack;
                if (msg.arg1 <= 0) break;
                byte[] readBuf = (byte[])msg.obj;
                if (D) {
                    String readMessage = new String(readBuf, 0, msg.arg1);
                    Log.d((String)TAG, (String)("[" + msg.arg1 + "] MESSAGE_READ: " + Utility.toHexString(Utility.copyOfRange(readBuf, 0, msg.arg1)) + "\nreadMessage: " + readMessage));
                }
                if (isAutoStatusBack = this.handleAutoStatusBack(readBuf, msg.arg1)) {
                    if (msg.arg1 <= 4) break;
                    this.dispatchMessage(Utility.copyOfRange(readBuf, 4, msg.arg1));
                    break;
                }
                this.dispatchMessage(Utility.copyOfRange(readBuf, 0, msg.arg1));
                break;
            }
            case 4: {
                String connectedDeviceName = msg.getData().getString("device_name");
                msg = this.obtainMessage(4, this.mServiceManager.getPrinterObjectHashCode());
                Bundle bundle = new Bundle();
                bundle.putString("device_name", connectedDeviceName);
                msg.setData(bundle);
                this.mApplicationHandler.sendMessage(msg);
                break;
            }
            case 5: {
                String value = msg.getData().getString("toast");
                msg = this.obtainMessage(5, this.mServiceManager.getPrinterObjectHashCode());
                Bundle bundle = new Bundle();
                bundle.putString("toast", value);
                msg.setData(bundle);
                this.mApplicationHandler.sendMessage(msg);
                break;
            }
            case 6: {
                if (!D) break;
                Log.d((String)TAG, (String)((String)msg.obj));
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                this.mApplicationHandler.obtainMessage(msg.what, msg.obj).sendToTarget();
            }
        }
    }

    private boolean handleAutoStatusBack(byte[] readBuf, int bufLength) {
        if (D) {
            Log.d((String)TAG, (String)("readBuf.length : " + readBuf.length));
        }
        if (readBuf.length == 1 && (readBuf[0] & 1) == 0 && (readBuf[0] & 2) == 0 && (readBuf[0] & 0x10) == 16 && (readBuf[0] & 0x80) == 0) {
            this.readDataBuf.put(readBuf);
        } else if (readBuf.length == 3 && (readBuf[0] & 1) == 0 && (readBuf[0] & 2) == 0 && (readBuf[0] & 0x80) == 0 && (readBuf[1] & 0x10) == 0 && (readBuf[1] & 0x20) == 0 && (readBuf[1] & 0x40) == 0 && (readBuf[1] & 0x80) == 0 && readBuf[2] == 15) {
            this.readDataBuf.put(readBuf);
        } else if (readBuf.length == 4 && (readBuf[0] & 1) == 0 && (readBuf[0] & 2) == 0 && (readBuf[0] & 0x10) == 16 && (readBuf[0] & 0x80) == 0 && (readBuf[2] & 0x20) == 0 && (readBuf[2] & 0x40) == 0 && (readBuf[2] & 0x80) == 0 && readBuf[3] == 15) {
            this.readDataBuf.put(readBuf);
        }
        if (this.readDataBuf.position() == 4 && (this.readDataBuf.get(0) & 1) == 0 && (this.readDataBuf.get(0) & 2) == 0 && (this.readDataBuf.get(0) & 0x10) == 16 && (this.readDataBuf.get(0) & 0x80) == 0 && (this.readDataBuf.get(2) & 0x20) == 0 && (this.readDataBuf.get(2) & 0x40) == 0 && (this.readDataBuf.get(2) & 0x80) == 0 && this.readDataBuf.get(3) == 15) {
            byte[] array1 = Utility.copyOfRange(this.readDataBuf.array(), 0, 4);
            this.readDataBuf.clear();
            if (D) {
                Log.d((String)TAG, (String)("readBuf.length : " + readBuf.length));
                Log.d((String)TAG, (String)("array1 : " + Utility.toHexString(array1)));
                Log.d((String)TAG, (String)("mAutoStatusBack : " + Utility.toHexString(this.mAutoStatusBack)));
            }
            if (!Arrays.equals(array1, this.mAutoStatusBack)) {
                this.mAutoStatusBack = array1;
                int response = 0;
                if ((this.mAutoStatusBack[0] & 8) == 8) {
                    response |= 8;
                }
                if ((this.mAutoStatusBack[0] & 0x20) == 32) {
                    response |= 0x20;
                }
                if ((this.mAutoStatusBack[0] & 0x40) == 64) {
                    response |= 0x40;
                }
                if ((this.mAutoStatusBack[1] & 0x20) == 32) {
                    response |= 2;
                }
                if ((this.mAutoStatusBack[1] & 0x40) == 64) {
                    response |= 4;
                }
                if ((this.mAutoStatusBack[2] & 0xC) == 12) {
                    response |= 0xC;
                }
                this.mApplicationHandler.obtainMessage(2, 6, response, (Object)this.mServiceManager.getPrinterObjectHashCode()).sendToTarget();
            }
            return true;
        }
        return false;
    }

    public void dispatchMessage(byte[] message) {
        if (this.mCurrentProcess != 1 && this.mCurrentProcess != 3 && this.mCurrentProcess != 4 && this.mCurrentProcess != 9 && this.mCurrentProcess != 19 && this.mCurrentProcess != 20) {
            this.mReceiveBuffer.put(message);
        }
        if (D) {
            Log.d((String)TAG, (String)("dispatchMessage(" + Utility.toHexString(message) + ")"));
            Log.d((String)TAG, (String)("CurrentProcess: " + this.mCurrentProcess + ", ReceiveBuffer: " + Utility.toHexString(Utility.copyOfRange(this.mReceiveBuffer.array(), 0, this.mReceiveBuffer.position()))));
        }
        switch (this.mCurrentProcess) {
            case 1: {
                if (!new String(message).trim().equals("_Metapace Identsystem GmbH")) break;
                this.mCurrentProcess = 0;
                this.mApplicationHandler.obtainMessage(8, (Object)this.mServiceManager.getPrinterObjectHashCode()).sendToTarget();
                break;
            }
            case 22: {
                String modelName = new String(this.mReceiveBuffer.array()).trim();
                if ((this.mReceiveBuffer.get(0) != 95 || this.mReceiveBuffer.get(this.mReceiveBuffer.position() - 1) != 0) && modelName.indexOf("300") < 0) break;
                if (this.mServiceManager.setPrinterModel(modelName)) {
                    this.mApplicationHandler.obtainMessage(1, 2, -1, (Object)this.mServiceManager.getPrinterObjectHashCode()).sendToTarget();
                } else {
                    this.mServiceManager.disconnect();
                }
                this.mCurrentProcess = 0;
                this.mReceiveBuffer.clear();
                break;
            }
            case 3: {
                if (message.length != 1) break;
                if ((message[0] & 4) == 4) {
                    this.mStatus |= 4;
                }
                if ((message[0] & 8) == 8) {
                    this.mStatus |= 8;
                }
                if ((message[0] & 0x20) == 32) {
                    this.mStatus |= 0x20;
                }
                if ((message[0] & 0x40) == 64) {
                    this.mStatus |= 0x40;
                }
                this.mCurrentProcess = 4;
                this.mServiceManager.executeCommand(this.mCurrentProcess, 0);
                break;
            }
            case 4: {
                if (message.length != 1) break;
                if ((message[0] & 0x60) == 96) {
                    this.mStatus |= 0x60;
                }
                this.mCurrentProcess = 0;
                this.mApplicationHandler.obtainMessage(2, 2, this.mStatus, (Object)this.mServiceManager.getPrinterObjectHashCode()).sendToTarget();
                this.mStatus = 0;
                break;
            }
            case 5: {
                if (this.mReceiveBuffer.get(0) != 95 || this.mReceiveBuffer.get(this.mReceiveBuffer.position() - 1) != 0) break;
                this.mCurrentProcess = 0;
                byte[] data = new byte[this.mReceiveBuffer.position() - 1];
                int i = 1;
                while (this.mReceiveBuffer.get(i) != 0 && i < this.mReceiveBuffer.position()) {
                    data[i - 1] = this.mReceiveBuffer.get(i);
                    ++i;
                }
                String value = new String(data);
                value = value.trim();
                Message msg = this.mApplicationHandler.obtainMessage(2, 5, -1, (Object)this.mServiceManager.getPrinterObjectHashCode());
                Bundle bundle = new Bundle();
                bundle.putString("printer_id", value);
                msg.setData(bundle);
                this.mApplicationHandler.sendMessage(msg);
                this.mReceiveBuffer.clear();
                break;
            }
            case 9: {
                this.mCurrentProcess = 0;
                Message msg = this.mApplicationHandler.obtainMessage(2, 9, -1, (Object)this.mServiceManager.getPrinterObjectHashCode());
                Bundle data = new Bundle();
                data.putByteArray("direct_io", message);
                msg.setData(data);
                this.mApplicationHandler.sendMessage(msg);
                break;
            }
            case 18: {
                if (this.mReceiveBuffer.position() < 4 || this.mReceiveBuffer.get(0) != 55 || this.mReceiveBuffer.get(1) != 114 || this.mReceiveBuffer.get(2) != 64 || this.mReceiveBuffer.get(this.mReceiveBuffer.position() - 1) != 0) break;
                this.mCurrentProcess = 0;
                this.mServiceManager.executeCommand(new byte[]{6}, false);
                ArrayList<Integer> keyCodeList = new ArrayList<Integer>();
                int i = 3;
                while (i < this.mReceiveBuffer.position() - 1 && this.mReceiveBuffer.get(i) != 0) {
                    keyCodeList.add((this.mReceiveBuffer.get(i) - 48) * 10 + (this.mReceiveBuffer.get(i + 1) - 48));
                    i += 2;
                }
                Message msg = this.mApplicationHandler.obtainMessage(2, 18, -1, (Object)this.mServiceManager.getPrinterObjectHashCode());
                if (keyCodeList.size() > 0) {
                    int[] array = new int[keyCodeList.size()];
                    int i2 = 0;
                    while (i2 < array.length) {
                        array[i2] = (Integer)keyCodeList.get(i2);
                        ++i2;
                    }
                    Arrays.sort(array);
                    Bundle bundle = new Bundle();
                    bundle.putIntArray("nv_image_key_codes", array);
                    msg.setData(bundle);
                }
                this.mApplicationHandler.sendMessage(msg);
                this.mReceiveBuffer.clear();
                break;
            }
            case 19: {
                this.mCurrentProcess = 0;
                this.mApplicationHandler.obtainMessage(3, 19, -1, (Object)this.mServiceManager.getPrinterObjectHashCode()).sendToTarget();
                break;
            }
            case 20: {
                this.mCurrentProcess = 0;
                this.mApplicationHandler.obtainMessage(3, 20, -1, (Object)this.mServiceManager.getPrinterObjectHashCode()).sendToTarget();
            }
        }
    }
}

