/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.property;

import android.util.Log;
import com.metapace.thermalprinter.MetapacePrinter;
import com.metapace.thermalprinter.charset.Cp437;
import com.metapace.thermalprinter.charset.Cp737;
import com.metapace.thermalprinter.charset.Cp775;
import com.metapace.thermalprinter.charset.Cp850;
import com.metapace.thermalprinter.charset.Cp852;
import com.metapace.thermalprinter.charset.Cp855;
import com.metapace.thermalprinter.charset.Cp857;
import com.metapace.thermalprinter.charset.Cp858;
import com.metapace.thermalprinter.charset.Cp860;
import com.metapace.thermalprinter.charset.Cp862;
import com.metapace.thermalprinter.charset.Cp863;
import com.metapace.thermalprinter.charset.Cp864;
import com.metapace.thermalprinter.charset.Cp865;
import com.metapace.thermalprinter.charset.Cp866;
import com.metapace.thermalprinter.charset.Cp928;
import com.metapace.thermalprinter.charset.Farsi;
import com.metapace.thermalprinter.charset.Katakana;
import com.metapace.thermalprinter.charset.KhmerCambodia;
import com.metapace.thermalprinter.charset.Thai11;
import com.metapace.thermalprinter.charset.Thai14;
import com.metapace.thermalprinter.charset.Thai16;
import com.metapace.thermalprinter.charset.Thai18;
import com.metapace.thermalprinter.charset.Thai42;
import com.metapace.thermalprinter.charset.Windows1250;
import com.metapace.thermalprinter.charset.Windows1251;
import com.metapace.thermalprinter.charset.Windows1252;
import com.metapace.thermalprinter.charset.Windows1253;
import com.metapace.thermalprinter.charset.Windows1254;
import com.metapace.thermalprinter.charset.Windows1255;
import com.metapace.thermalprinter.charset.Windows1256;
import com.metapace.thermalprinter.charset.Windows1257;
import com.metapace.thermalprinter.charset.Windows1258;
import com.metapace.thermalprinter.utility.Command;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Locale;

public final class CodePageManager {
    private static final String TAG = CodePageManager.class.getSimpleName();
    private static final boolean D = MetapacePrinter.D;
    public static final byte DOUBLE_BYTE_FONT_KOREAN = 124;
    public static final byte DOUBLE_BYTE_FONT_CHINESE_BIG5 = 125;
    public static final byte DOUBLE_BYTE_FONT_CHINESE_GB2312 = 126;
    public static final byte DOUBLE_BYTE_FONT_JAPANESE = 127;
    private static final byte[][] MEMORY_SWITCH2 = new byte[][]{{48, 48, 48, 48, 48, 48, 48, 48}, {48, 48, 48, 48, 49, 48, 48, 48}, {48, 48, 48, 49, 48, 48, 48, 48}, {48, 48, 48, 49, 49, 48, 48, 48}, {48, 48, 49, 48, 48, 48, 48, 48}, {48, 48, 49, 48, 49, 48, 48, 48}, {48, 48, 49, 49, 48, 48, 48, 48}, {48, 48, 49, 49, 49, 48, 48, 48}, {48, 49, 48, 48, 48, 48, 48, 48}, {48, 49, 48, 48, 49, 48, 48, 48}, {48, 49, 48, 49, 48, 48, 48, 48}, {48, 49, 48, 49, 49, 48, 48, 48}, {48, 49, 49, 48, 48, 48, 48, 48}, {48, 49, 49, 48, 49, 48, 48, 48}, {48, 49, 49, 49, 48, 48, 48, 48}, {48, 49, 49, 49, 49, 48, 48, 48}, {49, 48, 48, 48, 48, 48, 48, 48}, {49, 48, 48, 48, 49, 48, 48, 48}, {49, 48, 48, 49, 48, 48, 48, 48}, {49, 48, 48, 49, 49, 48, 48, 48}, {49, 48, 49, 48, 48, 48, 48, 48}, {49, 48, 49, 48, 49, 48, 48, 48}, {49, 48, 49, 49, 48, 48, 48, 48}, {49, 48, 49, 49, 49, 48, 48, 48}, {49, 49, 48, 48, 48, 48, 48, 48}, {49, 49, 48, 48, 49, 48, 48, 48}, {49, 49, 48, 49, 48, 48, 48, 48}, {49, 49, 48, 49, 49, 48, 48, 48}, {49, 49, 49, 48, 48, 48, 48, 48}, {49, 49, 49, 48, 49, 48, 48, 48}, {49, 49, 49, 49, 48, 48, 48, 48}, {49, 49, 49, 49, 49, 48, 48, 48}, {48, 48, 49, 48, 48, 49, 48, 48}};
    private static final byte[][] MEMORY_SWITCH12 = new byte[][]{{48, 48, 48, 48, 48, 48, 48, 49}, {48, 48, 48, 48, 48, 48, 49, 48}, {48, 48, 48, 48, 48, 48, 49, 48}, {48, 48, 48, 48, 48, 48, 49, 49}};
    private static final String[] SINGLE_BYTE_CODE_PAGE_NAME = new String[]{"Page 0 437(USA, standard Europe)", "Page 1 Katakana", "Page 2 850 (Multilingual)", "Page 3 860 (Portuguese)", "Page 4 863 (Canadian-French)", "Page 5 865 (Nordic)", "Page 16 1252 (Latin I)", "Page 17 866 (Cyrillic #2)", "Page 18 852 (Latin 2)", "Page 19 858 (Euro)", "Page 21 862 (Hebrew DOS code)", "Page 22 864 (Arabic)", "Page 23 Thai42", "Page 24 1253 (Greek)", "Page 25 1254 (Turkish)", "Page 26 1257 (Baltic)", "Page 27 Farsi", "Page 28 1251 (Cyrillic)", "Page 29 737 (Greek)", "Page 30 775 (Baltic)", "Page 31 Thai14", "Page 32 Hebrew Old code", "Page 33 1255 (Hebrew Newcode)", "Page 34 Thai11", "Page 35 Thai18", "Page 36 855 (Cyrillic)", "Page 37 857 (Turkish)", "Page 38 928 (Greek)", "Page 39 Thai16", "Page 40 1256 (ARB)", "Page 41 1258 (Vietnam)", "Page 42 Khmer (Cambodia)", "Page 47 1250 (Czech)"};
    private static String[] DOUBLE_BYTE_CODE_PAGE_NAME = new String[]{"KS5601", "BIG5", "GB2312", "SHIFT-JIS"};

    public static byte[] getBytes(String text, int codePage) {
        byte[] bytes = null;
        switch (codePage) {
            case 0: {
                bytes = text.getBytes(new Cp437());
                break;
            }
            case 1: {
                bytes = text.getBytes(new Katakana());
                break;
            }
            case 2: {
                bytes = text.getBytes(new Cp850());
                break;
            }
            case 3: {
                bytes = text.getBytes(new Cp860());
                break;
            }
            case 4: {
                bytes = text.getBytes(new Cp863());
                break;
            }
            case 5: {
                bytes = text.getBytes(new Cp865());
                break;
            }
            case 16: {
                bytes = text.getBytes(new Windows1252());
                break;
            }
            case 17: {
                bytes = text.getBytes(new Cp866());
                break;
            }
            case 18: {
                bytes = text.getBytes(new Cp852());
                break;
            }
            case 19: {
                bytes = text.getBytes(new Cp858());
                break;
            }
            case 21: {
                bytes = text.getBytes(new Cp862());
                break;
            }
            case 22: {
                bytes = text.getBytes(new Cp864());
                break;
            }
            case 23: {
                bytes = text.getBytes(new Thai42());
                break;
            }
            case 24: {
                bytes = text.getBytes(new Windows1253());
                break;
            }
            case 25: {
                bytes = text.getBytes(new Windows1254());
                break;
            }
            case 26: {
                bytes = text.getBytes(new Windows1257());
                break;
            }
            case 27: {
                bytes = text.getBytes(new Farsi());
                break;
            }
            case 28: {
                bytes = text.getBytes(new Windows1251());
                break;
            }
            case 29: {
                bytes = text.getBytes(new Cp737());
                break;
            }
            case 30: {
                bytes = text.getBytes(new Cp775());
                break;
            }
            case 31: {
                bytes = text.getBytes(new Thai14());
                break;
            }
            case 33: {
                bytes = text.getBytes(new Windows1255());
                break;
            }
            case 34: {
                bytes = text.getBytes(new Thai11());
                break;
            }
            case 35: {
                bytes = text.getBytes(new Thai18());
                break;
            }
            case 36: {
                bytes = text.getBytes(new Cp855());
                break;
            }
            case 37: {
                bytes = text.getBytes(new Cp857());
                break;
            }
            case 38: {
                bytes = text.getBytes(new Cp928());
                break;
            }
            case 39: {
                bytes = text.getBytes(new Thai16());
                break;
            }
            case 40: {
                bytes = text.getBytes(new Windows1256());
                break;
            }
            case 41: {
                bytes = text.getBytes(new Windows1258());
                break;
            }
            case 42: {
                bytes = text.getBytes(new KhmerCambodia());
                break;
            }
            case 47: {
                bytes = text.getBytes(new Windows1250());
                break;
            }
            default: {
                Locale locale = Locale.getDefault();
                String language = locale.getLanguage();
                String country = locale.getCountry();
                if (D) {
                    Log.d((String)TAG, (String)("Default Locale: " + locale + ", Language: " + language + ", Country: " + country));
                }
                try {
                    if (language.equals(new Locale("ko").getLanguage())) {
                        bytes = text.getBytes("EUC_KR");
                        if (!D) break;
                        Log.d((String)TAG, (String)("EUC_KR: " + new String(bytes, "EUC_KR")));
                        break;
                    }
                    if (language.equals(new Locale("ja").getLanguage())) {
                        bytes = text.getBytes("SHIFT_JIS");
                        if (!D) break;
                        Log.d((String)TAG, (String)("SHIFT_JIS: " + new String(bytes, "SHIFT_JIS")));
                        break;
                    }
                    if (language.equals(new Locale("zh").getLanguage())) {
                        if (country.equals("CN")) {
                            bytes = text.getBytes("EUC_CN");
                            if (!D) break;
                            Log.d((String)TAG, (String)("EUC_CN: " + new String(bytes, "EUC_CN")));
                            break;
                        }
                        bytes = text.getBytes("BIG5");
                        if (!D) break;
                        Log.d((String)TAG, (String)("BIG5: " + new String(bytes, "BIG5")));
                        break;
                    }
                    bytes = text.getBytes();
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    bytes = text.getBytes();
                }
            }
        }
        if (D && text != null) {
            Log.d((String)TAG, (String)("Text length: " + text.length() + ", Bytes Length: " + bytes.length));
        }
        return bytes;
    }

    public static byte[] getCodePageCommand(int codePage, boolean isDoubleByteFont) {
        if (isDoubleByteFont) {
            switch (codePage) {
                case 124: {
                    return Command.KS5601;
                }
                case 125: 
                case 126: {
                    return Command.BIG5_GB2312;
                }
                case 127: {
                    return Command.SHIFT_JIS;
                }
            }
            return null;
        }
        switch (codePage) {
            case 0: {
                return Command.CODE_PAGE_437_USA;
            }
            case 1: {
                return Command.CODE_PAGE_KATAKANA;
            }
            case 2: {
                return Command.CODE_PAGE_850_MULTILINGUAL;
            }
            case 3: {
                return Command.CODE_PAGE_860_PORTUGUESE;
            }
            case 4: {
                return Command.CODE_PAGE_863_CCANADIAN_FRENCH;
            }
            case 5: {
                return Command.CODE_PAGE_865_NORDIC;
            }
            case 16: {
                return Command.CODE_PAGE_1252_LATIN1;
            }
            case 17: {
                return Command.CODE_PAGE_866_CYRILLIC2;
            }
            case 18: {
                return Command.CODE_PAGE_852_LATIN2;
            }
            case 19: {
                return Command.CODE_PAGE_858_EURO;
            }
            case 21: {
                return Command.CODE_PAGE_862_HEBREW_DOS_CODE;
            }
            case 22: {
                return Command.CODE_PAGE_864_ARABIC;
            }
            case 23: {
                return Command.CODE_PAGE_THAI42;
            }
            case 24: {
                return Command.CODE_PAGE_1253_GREEK;
            }
            case 25: {
                return Command.CODE_PAGE_1254_TURKISH;
            }
            case 26: {
                return Command.CODE_PAGE_1257_BALTIC;
            }
            case 27: {
                return Command.CODE_PAGE_FARSI;
            }
            case 28: {
                return Command.CODE_PAGE_1251_CYRILLIC;
            }
            case 29: {
                return Command.CODE_PAGE_737_GREEK;
            }
            case 30: {
                return Command.CODE_PAGE_775_BALTIC;
            }
            case 31: {
                return Command.CODE_PAGE_THAI14;
            }
            case 33: {
                return Command.CODE_PAGE_1255_HEBREW_NEW_CODE;
            }
            case 34: {
                return Command.CODE_PAGE_THAI11;
            }
            case 35: {
                return Command.CODE_PAGE_THAI18;
            }
            case 36: {
                return Command.CODE_PAGE_855_CYRILLIC;
            }
            case 37: {
                return Command.CODE_PAGE_857_TURKISH;
            }
            case 38: {
                return Command.CODE_PAGE_928_GREEK;
            }
            case 39: {
                return Command.CODE_PAGE_THAI16;
            }
            case 40: {
                return Command.CODE_PAGE_1256_ARB;
            }
            case 41: {
                return Command.CODE_PAGE_1258_VIETNAM;
            }
            case 42: {
                return Command.CODE_PAGE_KHMER_CAMBODIA;
            }
            case 47: {
                return Command.CODE_PAGE_1250_CZECH;
            }
        }
        return null;
    }

    public static String getSingleByteCodePageName(byte[] memorySwitch) {
        int i = 0;
        while (i < MEMORY_SWITCH2.length) {
            if (Arrays.equals(memorySwitch, MEMORY_SWITCH2[i])) {
                return SINGLE_BYTE_CODE_PAGE_NAME[i];
            }
            ++i;
        }
        return null;
    }

    public static String getDoubleByteCodePageName(byte[] memorySwitch) {
        int i = 0;
        while (i < MEMORY_SWITCH12.length) {
            if (Arrays.equals(memorySwitch, MEMORY_SWITCH12[i])) {
                return DOUBLE_BYTE_CODE_PAGE_NAME[i];
            }
            ++i;
        }
        return null;
    }
}

