/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.charset;

import com.metapace.thermalprinter.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

abstract class ByteCharset
extends Charset {
    protected char[] lookupTable;
    protected static final char NONE = '\ufffd';

    ByteCharset(String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof US_ASCII || cs.getClass() == this.getClass();
    }

    char[] getLookupTable() {
        return this.lookupTable;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Decoder
    extends CharsetDecoder {
        private char[] lookup;

        Decoder(ByteCharset cs) {
            super(cs, 1.0f, 1.0f);
            this.lookup = cs.getLookupTable();
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                byte b = in.get();
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                char c = this.lookup[b & 0xFF];
                if (c == '\ufffd') {
                    // empty if block
                }
                out.put(c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private byte[] lookup;

        Encoder(ByteCharset cs) {
            super(cs, 1.0f, 1.0f);
            char c;
            char[] lookup_table = cs.getLookupTable();
            char max = '\u0000';
            int i = 0;
            while (i < lookup_table.length) {
                c = lookup_table[i];
                max = c > max && c < '\ufffd' ? c : max;
                ++i;
            }
            this.lookup = new byte[max + 1];
            i = 0;
            while (i < lookup_table.length) {
                c = lookup_table[i];
                if (c != '\u0000' && c < '\ufffd') {
                    this.lookup[c] = (byte)i;
                }
                ++i;
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                byte b;
                char c = in.get();
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                byte by = b = c < this.lookup.length ? this.lookup[c] : (byte)0;
                if (b != 0 || c == '\u0000') {
                    out.put(b);
                    continue;
                }
                in.position(in.position() - 1);
                return CoderResult.unmappableForLength(1);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

