/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.print;

import android.util.Log;
import com.metapace.thermalprinter.MetapacePrinter;
import com.metapace.thermalprinter.utility.Command;
import java.nio.ByteBuffer;

public final class BarCodeManager {
    private static final String TAG = BarCodeManager.class.getSimpleName();
    private static final boolean D = MetapacePrinter.D;
    private static boolean mIsOverFlow = false;
    private static final int INDEX_NUMERIC = 0;
    private static final int INDEX_ALPAH_NUMERIC = 1;
    private static final int INDEX_BINARY = 2;
    private static final int[][][] VALIDATION_TABLE = new int[][][]{new int[][]{{41, 25, 17}, {34, 20, 14}, {27, 16, 11}, {17, 10, 7}}, new int[][]{{77, 47, 32}, {63, 38, 26}, {48, 29, 20}, {34, 20, 14}}, new int[][]{{127, 77, 53}, {101, 61, 42}, {77, 47, 32}, {58, 35, 24}}, new int[][]{{187, 114, 78}, {149, 90, 62}, {111, 67, 46}, {82, 50, 34}}, new int[][]{{255, 154, 106}, {202, 122, 84}, {144, 87, 60}, {106, 64, 44}}, new int[][]{{322, 195, 134}, {255, 154, 106}, {178, 108, 74}, {139, 84, 58}}, new int[][]{{370, 224, 154}, {293, 178, 122}, {207, 125, 86}, {154, 93, 64}}, new int[][]{{461, 279, 192}, {365, 221, 152}, {259, 157, 108}, {202, 122, 84}}, new int[][]{{552, 335, 230}, {432, 262, 180}, {312, 189, 130}, {235, 143, 98}}, new int[][]{{652, 395, 271}, {513, 311, 213}, {364, 221, 151}, {288, 174, 119}}, new int[][]{{772, 468, 321}, {604, 366, 251}, {427, 259, 177}, {331, 200, 137}}, new int[][]{{883, 535, 367}, {691, 419, 287}, {489, 296, 203}, {374, 227, 155}}, new int[][]{{1022, 619, 425}, {796, 483, 331}, {580, 352, 241}, {427, 259, 177}}, new int[][]{{1101, 667, 458}, {871, 528, 362}, {621, 376, 258}, {468, 283, 194}}, new int[][]{{1250, 758, 520}, {991, 600, 412}, {703, 426, 292}, {530, 321, 220}}, new int[][]{{1408, 854, 586}, {1082, 656, 450}, {775, 470, 322}, {602, 365, 250}}, new int[][]{{1548, 938, 644}, {1212, 734, 504}, {876, 531, 364}, {674, 408, 280}}, new int[][]{{1725, 1046, 718}, {1346, 816, 560}, {948, 574, 394}, {746, 452, 310}}, new int[][]{{1903, 1153, 792}, {1500, 909, 624}, {1063, 644, 422}, {813, 493, 338}}, new int[][]{{2061, 1249, 858}, {1600, 970, 666}, {1159, 702, 482}, {919, 557, 382}}, new int[][]{{2232, 1352, 929}, {1708, 1035, 771}, {1224, 742, 509}, {969, 587, 403}}, new int[][]{{2409, 1460, 1003}, {1872, 1134, 779}, {1358, 823, 565}, {1056, 640, 439}}, new int[][]{{2620, 1588, 1091}, {2059, 1248, 857}, {1468, 890, 611}, {1108, 672, 461}}, new int[][]{{2812, 1704, 1171}, {2188, 1326, 911}, {1588, 963, 661}, {1228, 744, 511}}, new int[][]{{3057, 1853, 1273}, {2395, 1451, 997}, {1718, 1041, 715}, {1286, 779, 535}}, new int[][]{{3283, 1990, 1367}, {2544, 1542, 1059}, {1804, 1094, 751}, {1425, 864, 593}}, new int[][]{{3514, 2132, 1465}, {2701, 1637, 1125}, {1933, 1172, 805}, {1501, 910, 625}}, new int[][]{{3669, 2223, 1528}, {2857, 1732, 1190}, {2085, 1263, 868}, {1581, 958, 658}}, new int[][]{{3909, 2369, 1628}, {3035, 1839, 1264}, {2181, 1322, 908}, {1677, 1016, 698}}, new int[][]{{4158, 2520, 1732}, {3289, 1994, 1370}, {2358, 1429, 982}, {1782, 1080, 742}}, new int[][]{{4417, 2677, 1840}, {3486, 2113, 1452}, {2473, 1499, 1030}, {1897, 1150, 790}}, new int[][]{{4686, 2840, 1952}, {3693, 2238, 1538}, {2670, 1618, 1112}, {2022, 1226, 842}}, new int[][]{{4965, 3009, 2068}, {3909, 2369, 1628}, {2805, 1700, 1168}, {2157, 1307, 898}}, new int[][]{{5253, 3183, 2188}, {4134, 2506, 1722}, {2949, 1787, 1228}, {2301, 1394, 958}}, new int[][]{{5529, 3351, 2303}, {4343, 2632, 1809}, {3081, 1867, 1283}, {2361, 1431, 983}}, new int[][]{{5836, 3537, 2431}, {4588, 2780, 1911}, {3244, 1966, 1351}, {2524, 1530, 1051}}, new int[][]{{6153, 3729, 2563}, {4775, 2894, 1989}, {3417, 2071, 1423}, {2625, 1591, 1093}}, new int[][]{{6479, 3927, 2699}, {5039, 3054, 2099}, {3599, 2181, 1499}, {2735, 1658, 1139}}, new int[][]{{6743, 4087, 2809}, {5313, 3220, 2213}, {3791, 2298, 1579}, {2927, 1774, 1219}}, new int[][]{{7089, 4296, 2953}, {5596, 3391, 2331}, {3993, 2420, 1663}, {3057, 1852, 1273}}};

    private static void setAlignment(ByteBuffer buffer, int alignment) {
        switch (alignment) {
            case 1: {
                buffer.put(Command.ALIGNMENT_CENTER);
                break;
            }
            case 2: {
                buffer.put(Command.ALIGNMENT_RIGHT);
                break;
            }
            default: {
                buffer.put(Command.ALIGNMENT_LEFT);
            }
        }
    }

    private static void setWidth(ByteBuffer buffer, int width) {
        if (width < 1 || width > 6) {
            width = 3;
        }
        buffer.put(Command.BAR_CODE_WIDTH);
        buffer.put((byte)width);
    }

    private static void setHeight(ByteBuffer buffer, int height) {
        if (height < 1 || height > 255) {
            height = 162;
        }
        buffer.put(Command.BAR_CODE_HEIGHT);
        buffer.put((byte)height);
    }

    private static void setCharacterPosition(ByteBuffer buffer, int characterPosition) {
        switch (characterPosition) {
            case 1: {
                buffer.put(Command.HRI_CHARACTERS_ABOVE_BAR_CODE);
                break;
            }
            case 2: {
                buffer.put(Command.HRI_CHARACTERS_BELOW_BAR_CODE);
                break;
            }
            case 3: {
                buffer.put(Command.HRI_CHARACTERS_ABOVE_AND_BELOW_BAR_CODE);
                break;
            }
            default: {
                buffer.put(Command.HRI_CHARACTERS_NOT_PRINTED);
            }
        }
    }

    public static byte[] get1DBarCode(byte[] data, int barCodeSystem, int alignment, int width, int height, int characterPosition) {
        int capacity = Command.ALIGNMENT_LEFT.length + Command.BAR_CODE_WIDTH.length + 1 + Command.BAR_CODE_HEIGHT.length + 1 + Command.HRI_CHARACTERS_NOT_PRINTED.length + Command.BAR_CODE_UPC_A.length + 1 + data.length;
        if (barCodeSystem == 73 && data[0] != 123) {
            capacity += 2;
        }
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        BarCodeManager.setAlignment(buffer, alignment);
        BarCodeManager.setWidth(buffer, width);
        BarCodeManager.setHeight(buffer, height);
        BarCodeManager.setCharacterPosition(buffer, characterPosition);
        switch (barCodeSystem) {
            case 65: {
                if (data.length < 11 || data.length > 12) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (data[i] < 48 || data[i] > 57) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_UPC_A);
                buffer.put((byte)data.length);
                buffer.put(data);
                break;
            }
            case 66: {
                if (data.length < 11 || data.length > 12) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (i == 0 && data[i] != 48) {
                        return null;
                    }
                    if (data[i] < 48 || data[i] > 57) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_UPC_E);
                buffer.put((byte)data.length);
                buffer.put(data);
                break;
            }
            case 67: {
                if (data.length < 12 || data.length > 13) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (data[i] < 48 || data[i] > 57) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_EAN13);
                buffer.put((byte)data.length);
                buffer.put(data);
                break;
            }
            case 68: {
                if (data.length < 7 || data.length > 8) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (data[i] < 48 || data[i] > 57) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_EAN8);
                buffer.put((byte)data.length);
                buffer.put(data);
                break;
            }
            case 69: {
                if (data.length > 255) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (!(data[i] == 32 || data[i] == 36 || data[i] == 37 || data[i] == 42 || data[i] == 43 || data[i] == 45 || data[i] == 46 || data[i] == 47 || data[i] >= 48 && data[i] <= 57 || data[i] >= 65 && data[i] <= 90)) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_CODE39);
                buffer.put((byte)data.length);
                buffer.put(data);
                break;
            }
            case 70: {
                if (data.length > 255 || data.length % 2 != 0) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (data[i] < 48 || data[i] > 57) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_ITF);
                buffer.put((byte)data.length);
                buffer.put(data);
                break;
            }
            case 71: {
                if (data.length > 255) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (i == 0 && (data[i] < 65 || data[i] > 90)) {
                        return null;
                    }
                    if ((data[i] < 48 || data[i] > 57) && data[i] != 36 && data[i] != 43 && data[i] != 45 && data[i] != 46 && data[i] != 47 && data[i] != 58 && data[i] != 65 && data[i] != 66 && data[i] != 67 && data[i] != 68) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_CODABAR);
                buffer.put((byte)data.length);
                buffer.put(data);
                break;
            }
            case 72: {
                if (data.length > 255) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (data[i] < 0 || data[i] > 127) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_CODE93);
                buffer.put((byte)data.length);
                buffer.put(data);
                break;
            }
            case 73: {
                if (data.length < 2 || data.length > 255) {
                    return null;
                }
                int i = 0;
                while (i < data.length) {
                    if (data[i] < 0 || data[i] > 127) {
                        return null;
                    }
                    ++i;
                }
                buffer.put(Command.BAR_CODE_CODE128);
                if (data[0] != 123) {
                    buffer.put((byte)(data.length + 2));
                    buffer.put((byte)123);
                    buffer.put((byte)65);
                }
                buffer.put(data);
                break;
            }
            default: {
                return null;
            }
        }
        return buffer.array();
    }

    public static byte[] getPdf417(byte[] data, int width, int height) {
        if (width < 2 || width > 3) {
            width = 3;
        }
        if (height < 2 || height > 8) {
            height = 3;
        }
        int capacity = Command.PDF417_COLUMN_NUMBER_AUTO.length + Command.PDF417_ROW_NUMBER_AUTO.length + Command.PDF417_WIDTH.length + 1 + Command.PDF417_HEIGHT.length + 1 + Command.PDF417_STORE.length + 2 + Command.PDF417_STORE_PARAMETER.length + data.length + Command.PDF417_PRINT.length;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.PDF417_COLUMN_NUMBER_AUTO);
        buffer.put(Command.PDF417_ROW_NUMBER_AUTO);
        buffer.put(Command.PDF417_WIDTH);
        buffer.put((byte)width);
        buffer.put(Command.PDF417_HEIGHT);
        buffer.put((byte)height);
        buffer.put(Command.PDF417_STORE);
        buffer.put((byte)((data.length + 3) % 256));
        buffer.put((byte)((data.length + 3) / 256));
        buffer.put(Command.PDF417_STORE_PARAMETER);
        buffer.put(data);
        buffer.put(Command.PDF417_PRINT);
        return buffer.array();
    }

    public static boolean isOverFlow() {
        return mIsOverFlow;
    }

    public static byte[] getQrCode(byte[] data, int model, int size, int errorCorrectionLevel, int version) {
        if (D) {
            Log.d((String)TAG, (String)("getQrCode(" + new String(data) + ", " + model + ", " + size + ", " + errorCorrectionLevel + ", " + version + ")"));
        }
        mIsOverFlow = false;
        if (size <= 0 || size >= 9) {
            size = 3;
        }
        if (D) {
            Log.d((String)TAG, (String)("data length: " + data.length));
        }
        if (data == null || data.length == 0 || model != 49 && model != 50 || errorCorrectionLevel < 48 || errorCorrectionLevel > 51) {
            return null;
        }
        int capacity = Command.QR_CODE_MODEL2.length + Command.QR_CODE_SIZE.length + 1 + Command.QR_CODE_ERROR_CORRECTION_LEVEL.length + 1 + Command.QR_CODE_STORE.length + 2 + Command.QR_CODE_STORE_PARAMETER.length + data.length + Command.QR_CODE_PRINT.length;
        if (version > 0) {
            int maxLength;
            if (version < 1 || version > 40) {
                return null;
            }
            int type = 0;
            int i = 0;
            while (i < data.length) {
                int character = data[i] & 0xFF;
                if (character >= 65 && character <= 90 || character >= 97 && character <= 122 || character == 32 || character == 36 || character == 37 || character == 42 || character == 43 || character == 45 || character == 46 || character == 47 || character == 58) {
                    type = 1;
                } else if (character < 48 || character > 57) {
                    type = 2;
                    break;
                }
                ++i;
            }
            if (D) {
                Log.d((String)TAG, (String)("version: " + version + ", errorCorrectionLevel: " + errorCorrectionLevel + ", type: " + type + ", data.length: " + data.length));
            }
            boolean bl = mIsOverFlow = data.length > (maxLength = VALIDATION_TABLE[version - 1][errorCorrectionLevel - 48][type]);
            if (mIsOverFlow) {
                if (D) {
                    Log.d((String)TAG, (String)"INVALIDATE");
                }
                ByteBuffer buffer = ByteBuffer.allocate(maxLength);
                buffer.put(data, 0, maxLength);
                data = buffer.array();
                capacity = Command.QR_CODE_VERSION.length + 1 + Command.QR_CODE_MODEL2.length + Command.QR_CODE_SIZE.length + 1 + Command.QR_CODE_ERROR_CORRECTION_LEVEL.length + 1 + Command.QR_CODE_STORE.length + 2 + Command.QR_CODE_STORE_PARAMETER.length + data.length + Command.QR_CODE_PRINT.length;
            } else {
                if (D) {
                    Log.d((String)TAG, (String)"VALIDATE");
                }
                capacity += Command.QR_CODE_VERSION.length + 1;
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        if (version > 0) {
            if (version >= 20) {
                version = 6;
            }
            buffer.put(Command.QR_CODE_VERSION);
            buffer.put((byte)version);
        }
        if (model == 49) {
            buffer.put(Command.QR_CODE_MODEL1);
        } else {
            buffer.put(Command.QR_CODE_MODEL2);
        }
        buffer.put(Command.QR_CODE_SIZE);
        buffer.put((byte)size);
        buffer.put(Command.QR_CODE_ERROR_CORRECTION_LEVEL);
        buffer.put((byte)errorCorrectionLevel);
        buffer.put(Command.QR_CODE_STORE);
        buffer.put((byte)((data.length + 3) % 256));
        buffer.put((byte)((data.length + 3) / 256));
        buffer.put(Command.QR_CODE_STORE_PARAMETER);
        buffer.put(data);
        buffer.put(Command.QR_CODE_PRINT);
        return buffer.array();
    }

    public static byte[] getDataMatrix(byte[] data, int size) {
        if (size < 2 || size > 3) {
            size = 3;
        }
        int capacity = Command.DATA_MATRIX_SIZE.length + 1 + Command.DATA_MATRIX_STORE.length + 2 + Command.DATA_MATRIX_STORE_PARAMETER.length + data.length + Command.DATA_MATRIX_PRINT.length;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.DATA_MATRIX_SIZE);
        buffer.put((byte)size);
        buffer.put(Command.DATA_MATRIX_STORE);
        buffer.put((byte)((data.length + 3) % 256));
        buffer.put((byte)((data.length + 3) / 256));
        buffer.put(Command.DATA_MATRIX_STORE_PARAMETER);
        buffer.put(data);
        buffer.put(Command.DATA_MATRIX_PRINT);
        return buffer.array();
    }
}

