/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.connectivity;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.metapace.thermalprinter.MetapacePrinter;

public abstract class ConnectivityService {
    private static final String TAG = ConnectivityService.class.getSimpleName();
    protected static final boolean D = MetapacePrinter.D;
    protected final Handler mHandler;
    protected ConnectThread mConnectThread;
    protected ConnectedThread mConnectedThread;
    protected int mState = 0;

    ConnectivityService(Handler handler) {
        this.mHandler = handler;
    }

    protected synchronized void setState(int state) {
        if (D) {
            Log.d((String)TAG, (String)("setState() " + this.mState + " -> " + state));
        }
        if (this.mState != state) {
            this.mState = state;
            this.mHandler.obtainMessage(1, state, -1).sendToTarget();
        }
    }

    synchronized int getState() {
        return this.mState;
    }

    synchronized void stop() {
        if (D) {
            Log.d((String)TAG, (String)"stop");
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.setState(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] out) {
        ConnectedThread r;
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (this.mState != 2) {
                return;
            }
            r = this.mConnectedThread;
        }
        r.write(out);
    }

    protected void connectionFailed() {
        Message msg = this.mHandler.obtainMessage(5);
        Bundle bundle = new Bundle();
        bundle.putString("toast", "Unable to connect device");
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.stop();
    }

    protected void connectionLost() {
        Message msg = this.mHandler.obtainMessage(5);
        Bundle bundle = new Bundle();
        bundle.putString("toast", "Device connection was lost");
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.stop();
    }

    protected abstract class ConnectThread
    extends Thread {
        protected ConnectThread() {
        }

        abstract void cancel();
    }

    protected abstract class ConnectedThread
    extends Thread {
        protected ConnectedThread() {
        }

        abstract void write(byte[] var1);

        abstract void cancel();
    }
}

