/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.print;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import com.metapace.thermalprinter.MetapacePrinter;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class BitmapManager {
    private static final String TAG = "BitmapManager";
    private static final boolean D = MetapacePrinter.D;
    public static final int MODE_GSV0 = 0;
    public static final int MODE_ESC_8DOT = 8;

    private static int r(int word) {
        return ((word & 0xF800) >> 8) + 4;
    }

    private static int g(int word) {
        return ((word & 0x7E0) >> 3) + 2;
    }

    private static int b(int word) {
        return ((word & 0x1F) << 3) + 4;
    }

    private static int word(byte hi, byte lo) {
        return (hi & 0xFF) << 8 | lo & 0xFF;
    }

    public static int getBitmapHeight(Bitmap bitmap, int width) {
        int widthOfImage = bitmap.getWidth();
        int heightOfImage = bitmap.getHeight();
        double scale = 1.0;
        scale = (double)width / (double)widthOfImage;
        return (int)(scale * (double)heightOfImage);
    }

    public static byte[] bitmap2printerData(Bitmap bitmap, int width, int level, int mode) {
        int depth;
        boolean doAutoLevel;
        if (level >= 10000) {
            doAutoLevel = true;
            depth = 1;
            level -= 10000;
        } else {
            doAutoLevel = false;
            depth = 2;
        }
        if (level == 0) {
            level = 1;
        }
        int height = BitmapManager.getBitmapHeight(bitmap, width);
        byte[] prnData = BitmapManager.bitmap2Bytes(bitmap, width, height);
        BitmapManager.convertToGray(prnData, width, height, doAutoLevel);
        BitmapManager.makeDiffusionImageData(prnData, width, height, depth);
        switch (mode) {
            case 8: {
                prnData = BitmapManager.makeMonoImageData(prnData, width, height, level);
                break;
            }
            default: {
                prnData = BitmapManager.makeMonoGsvData(prnData, width, height, level, false);
            }
        }
        return prnData;
    }

    private static byte[] bitmap2Bytes(Bitmap bitmap, int width, int height) {
        Bitmap scaledImage1 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        Bitmap scaledImage = Bitmap.createBitmap((int)scaledImage1.getWidth(), (int)scaledImage1.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Paint ditherPaint = new Paint();
        ditherPaint.setDither(false);
        Paint whitePaint = new Paint();
        whitePaint.setColor(-1);
        Canvas canvas = new Canvas();
        canvas.setBitmap(scaledImage);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, whitePaint);
        canvas.drawBitmap(scaledImage1, 0.0f, 0.0f, ditherPaint);
        if (scaledImage1.hashCode() != bitmap.hashCode()) {
            scaledImage1.recycle();
            scaledImage1 = null;
        }
        if (D) {
            Log.i((String)"Support", (String)"source image has alpha channel. ( converted to RGB565: 16bit )");
        }
        ByteBuffer dataRgb = ByteBuffer.allocate(width * height * 2);
        scaledImage.copyPixelsToBuffer((Buffer)dataRgb);
        if (D) {
            Log.i((String)TAG, (String)("scaledImage " + scaledImage.getConfig()));
        }
        if (bitmap.hashCode() != scaledImage.hashCode()) {
            scaledImage.recycle();
            scaledImage = null;
        }
        dataRgb.position(0);
        byte[] prnData = BitmapManager.byteBuffer2Bytes(dataRgb, dataRgb.remaining(), width, height);
        dataRgb.clear();
        dataRgb = null;
        if (D) {
            Log.i((String)TAG, (String)("prnDataSize " + prnData.length + "[" + prnData.length + "]"));
        }
        return prnData;
    }

    public static byte[] byteBuffer2Bytes(ByteBuffer buffer, int size, int widthOfImage, int heightOfImage) {
        byte[] bytes = new byte[widthOfImage * heightOfImage * 4];
        int i = 0;
        int idx = 0;
        while (i < size) {
            int word = BitmapManager.word(buffer.get(i + 1), buffer.get(i));
            int r = BitmapManager.r(word);
            int g = BitmapManager.g(word);
            int b = BitmapManager.b(word);
            bytes[idx++] = (byte)r;
            bytes[idx++] = (byte)g;
            bytes[idx++] = (byte)b;
            bytes[idx++] = -1;
            i += 2;
        }
        return bytes;
    }

    public static void convertToGray(byte[] ptr, int width, int height, boolean doAutoLevel) {
        int idx;
        int w;
        int[] colorHistogram = new int[256];
        if (D) {
            Log.i((String)TAG, (String)"start to make GRAY SCALE with Auto Leveling");
        }
        int h = 0;
        while (h < height) {
            w = 0;
            while (w < width) {
                idx = 4 * (w + width * h);
                int r = BitmapManager.byte2Int(ptr[idx]);
                int g = BitmapManager.byte2Int(ptr[idx + 1]);
                int b = BitmapManager.byte2Int(ptr[idx + 2]);
                int leveled = (int)(0.2125 * (double)r + 0.7154 * (double)g + 0.0721 * (double)b);
                ptr[idx] = (byte)leveled;
                ptr[idx + 1] = ptr[idx];
                ptr[idx + 2] = ptr[idx];
                int n = leveled & 0xFF;
                colorHistogram[n] = colorHistogram[n] + 1;
                ++w;
            }
            ++h;
        }
        if (doAutoLevel) {
            float coefficient = (float)(255.0 / (double)(width * height));
            int i = 1;
            while (i < 256) {
                int n = i;
                colorHistogram[n] = colorHistogram[n] + colorHistogram[i - 1];
                ++i;
            }
            h = 0;
            while (h < height) {
                w = 0;
                while (w < width) {
                    idx = 4 * (w + width * h);
                    int gray_level = ptr[idx] & 0xFF;
                    byte gray_auto = (byte)Math.round((float)colorHistogram[gray_level] * coefficient);
                    byte by = (byte)(gray_auto > 255 ? -1 : (byte)gray_auto);
                    ptr[idx] = by;
                    ptr[idx + 1] = ptr[idx];
                    ptr[idx + 2] = ptr[idx];
                    ++w;
                }
                ++h;
            }
        }
    }

    public static int getNearest(int val, int depth) {
        switch (depth) {
            case 1: {
                return val < 128 ? 0 : 255;
            }
            case 2: {
                return (byte)(val / 64) * 64 + 32;
            }
            case 3: {
                return (byte)(val / 32) * 32 + 16;
            }
        }
        return val < 128 ? 0 : 255;
    }

    public static void makeDiffusionImageData(byte[] ptr, int width, int height, int depth) {
        if (D) {
            Log.i((String)TAG, (String)("make_diffusion_image_data: " + depth));
        }
        int nearest = 0;
        int quant = 0;
        int z = 0;
        int h = 0;
        while (h < height) {
            z = 0;
            int w = 0;
            while (w < width) {
                double temp;
                double blue;
                int idx = 4 * (w + width * h) + z;
                int val = BitmapManager.byte2Int(ptr[idx]);
                nearest = BitmapManager.getNearest(val, depth);
                quant = val - nearest;
                ptr[idx] = (byte)nearest;
                if (w + 1 < width) {
                    blue = 0.5375 * (double)quant;
                    temp = (double)BitmapManager.byte2Int(ptr[4 * (w + 1 + width * h) + z]) + blue;
                    ptr[4 * (w + 1 + width * h) + z] = temp < 0.0 ? 0 : (temp > 0.0 && temp < 255.0 ? (int)((int)Math.round(temp)) : -1);
                }
                if (h + 1 < height && w - 1 > 0) {
                    blue = 0.1875 * (double)quant;
                    temp = (double)BitmapManager.byte2Int(ptr[4 * (w - 1 + width * (h + 1)) + z]) + blue;
                    ptr[4 * (w - 1 + width * (h + 1)) + z] = temp < 0.0 ? 0 : (temp >= 0.0 && temp < 255.0 ? (int)((int)Math.round(temp)) : -1);
                }
                if (h + 1 < height) {
                    blue = 0.3125 * (double)quant;
                    temp = (double)BitmapManager.byte2Int(ptr[4 * (w + width * (h + 1)) + z]) + blue;
                    ptr[4 * (w + width * (h + 1)) + z] = temp < 0.0 ? 0 : (temp >= 0.0 && temp < 255.0 ? (int)((int)Math.round(temp)) : -1);
                }
                if (h + 1 < height && w + 1 < width) {
                    blue = 0.0625 * (double)quant;
                    temp = (double)BitmapManager.byte2Int(ptr[4 * (w + 1 + width * (h + 1)) + z]) + blue;
                    ptr[4 * (w + 1 + width * (h + 1)) + z] = temp < 0.0 ? 0 : (temp >= 0.0 && temp < 255.0 ? (int)((int)Math.round(temp)) : -1);
                }
                ptr[4 * (w + width * h) + z] = (byte)nearest;
                ptr[4 * (w + width * h) + 1] = (byte)nearest;
                ptr[4 * (w + width * h) + 2] = (byte)nearest;
                ++w;
            }
            ++h;
        }
    }

    private static byte getMonoDot(byte red, byte green, byte blue, int level) {
        int value = level * 255 / 100;
        if (BitmapManager.byte2Int(red) > value && BitmapManager.byte2Int(green) > value && BitmapManager.byte2Int(blue) > value) {
            return 0;
        }
        return 1;
    }

    public static byte[] makeMonoImageData(byte[] ptr, int width, int height, int level) {
        int heightDot = height / 8 + (height % 8 != 0 ? 1 : 0);
        int size = 4 + width * heightDot;
        byte[] data = new byte[size];
        int idx = 0;
        byte[] cols = new byte[8];
        int byteWidth = width / 8;
        if (width % 8 != 0) {
            byteWidth = width / 8 + 1;
        }
        data[idx++] = (byte)(byteWidth % 256);
        data[idx++] = (byte)(byteWidth / 256);
        data[idx++] = (byte)(heightDot % 256);
        data[idx++] = (byte)(heightDot / 256);
        int w = 0;
        while (w < width) {
            int h = 0;
            while (h < height) {
                int i = 0;
                while (i < 8) {
                    cols[i] = h + i < height ? BitmapManager.getMonoDot(ptr[4 * (w + width * (h + i)) + 0], ptr[4 * (w + width * (h + i)) + 1], ptr[4 * (w + width * (h + i)) + 2], level) : (byte)0;
                    ++i;
                }
                i = 0;
                while (i < 1) {
                    int shift = 0;
                    if (cols[0 + i * 8] == 1) {
                        shift |= 0x80;
                    }
                    if (cols[1 + i * 8] == 1) {
                        shift |= 0x40;
                    }
                    if (cols[2 + i * 8] == 1) {
                        shift |= 0x20;
                    }
                    if (cols[3 + i * 8] == 1) {
                        shift |= 0x10;
                    }
                    if (cols[4 + i * 8] == 1) {
                        shift |= 8;
                    }
                    if (cols[5 + i * 8] == 1) {
                        shift |= 4;
                    }
                    if (cols[6 + i * 8] == 1) {
                        shift |= 2;
                    }
                    if (cols[7 + i * 8] == 1) {
                        shift |= 1;
                    }
                    data[idx++] = (byte)shift;
                    ++i;
                }
                h += 8;
            }
            ++w;
        }
        cols = null;
        return data;
    }

    public static String log(int n) {
        String s = "";
        String s2 = "";
        int i = 0;
        while (i < Integer.numberOfLeadingZeros(n)) {
            s = String.valueOf(s) + "0";
            ++i;
        }
        s = String.valueOf(s) + Integer.toBinaryString(n);
        i = 0;
        while (i < 32) {
            s2 = String.valueOf(s2) + s.substring(i, i + 4) + " ";
            i += 4;
        }
        return s2;
    }

    static int byte2Int(byte n) {
        return n & 0xFF;
    }

    public static int bytesOfWidth(int width) {
        return width / 8 + (width % 8 != 0 ? 1 : 0);
    }

    public static byte[] makeMonoGsvData(byte[] ptr, int width, int height, int level, boolean addCommand) {
        byte[] data = null;
        int bytesOfWidth = BitmapManager.bytesOfWidth(width);
        int size = addCommand ? 8 + bytesOfWidth * height : bytesOfWidth * height;
        if (D) {
            Log.i((String)TAG, (String)("makeMonoGsvData[" + ptr.length + "]:" + size));
        }
        data = new byte[size];
        int bufIndex = 0;
        if (addCommand) {
            data[0] = 29;
            data[1] = 118;
            data[2] = 48;
            data[3] = 0;
            data[4] = (byte)(bytesOfWidth % 256);
            data[5] = (byte)(bytesOfWidth / 256);
            data[6] = (byte)(height % 256);
            data[7] = (byte)(height / 256);
            bufIndex = 8;
        }
        int idx = 0;
        int h = 0;
        while (h < height) {
            int count = 0;
            int w = 0;
            while (w < width) {
                idx = 4 * (w + width * h);
                int r = BitmapManager.byte2Int(ptr[idx]);
                int g = BitmapManager.byte2Int(ptr[idx + 1]);
                int b = BitmapManager.byte2Int(ptr[idx + 2]);
                int val = (int)((double)level * 255.0 / 100.0);
                int color = level != 0 && r >= val && g >= val && b >= val ? 0 : 1;
                int shift = 7 - w % 8;
                data[bufIndex] = (byte)(BitmapManager.byte2Int(data[bufIndex]) + (color << shift));
                if (count == 7) {
                    ++bufIndex;
                    count = 0;
                } else {
                    ++count;
                }
                ++w;
            }
            if (count != 0) {
                ++bufIndex;
            }
            ++h;
        }
        return data;
    }
}

