/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.connectivity;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.metapace.thermalprinter.connectivity.ConnectivityService;
import com.metapace.thermalprinter.utility.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public final class BluetoothService
extends ConnectivityService {
    private static final String TAG = "BluetoothService";
    private static final UUID MY_UUID_INSECURE = UUID.fromString("00001101-0000-1000-8000-00805f9B34fb");
    private final BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    static final String[] MAC_ADDRESS_PREFIXES = new String[]{"00:19:01", "00:06:6E", "74:F0:7D"};

    BluetoothService(Handler handler) {
        super(handler);
    }

    synchronized void connect(BluetoothDevice device, boolean secure) {
        if (D) {
            Log.d((String)TAG, (String)("connect to: " + device));
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(device, secure);
        this.mConnectThread.start();
        this.setState(1);
    }

    synchronized void connected(BluetoothSocket socket, BluetoothDevice device, String socketType) {
        if (D) {
            Log.d((String)TAG, (String)("connected, Socket Type: " + socketType));
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket, socketType);
        this.mConnectedThread.start();
        Message msg = this.mHandler.obtainMessage(4);
        Bundle bundle = new Bundle();
        bundle.putString("device_name", device.getName());
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.setState(2);
    }

    private class ConnectThread
    extends ConnectivityService.ConnectThread {
        private final BluetoothSocket mmSocket;
        private final BluetoothDevice mmDevice;
        private String mSocketType;

        ConnectThread(BluetoothDevice device, boolean secure) {
            super(BluetoothService.this);
            this.mmDevice = device;
            BluetoothSocket tmp = null;
            this.mSocketType = secure ? "Secure" : "Insecure";
            try {
                if (secure || Build.MODEL.indexOf("ME173X") >= 0 || Build.MODEL.indexOf("Lenovo") >= 0) {
                    tmp = device.createRfcommSocketToServiceRecord(MY_UUID_INSECURE);
                    if (D) {
                        Log.d((String)BluetoothService.TAG, (String)("createRfcommSocketToServiceRecord -> BluetoothSocket: " + tmp));
                    }
                } else {
                    tmp = device.createInsecureRfcommSocketToServiceRecord(MY_UUID_INSECURE);
                    if (D) {
                        Log.d((String)BluetoothService.TAG, (String)("createInsecureRfcommSocketToServiceRecord -> BluetoothSocket: " + tmp));
                    }
                }
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)("Socket Type: " + this.mSocketType + " create() failed"), (Throwable)e);
            }
            this.mmSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (D) {
                Log.i((String)BluetoothService.TAG, (String)("BEGIN mConnectThread SocketType: " + this.mSocketType));
            }
            this.setName("ConnectThread" + this.mSocketType);
            BluetoothService.this.mAdapter.cancelDiscovery();
            try {
                this.mmSocket.connect();
            }
            catch (IOException e) {
                try {
                    this.mmSocket.close();
                }
                catch (IOException e2) {
                    Log.e((String)BluetoothService.TAG, (String)("unable to close() " + this.mSocketType + " socket during connection failure"), (Throwable)e2);
                }
                BluetoothService.this.connectionFailed();
                return;
            }
            BluetoothService bluetoothService = BluetoothService.this;
            synchronized (bluetoothService) {
                BluetoothService.this.mConnectThread = null;
            }
            BluetoothService.this.connected(this.mmSocket, this.mmDevice, this.mSocketType);
        }

        @Override
        void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)("close() of connect " + this.mSocketType + "socket failed"), (Throwable)e);
            }
        }
    }

    private class ConnectedThread
    extends ConnectivityService.ConnectedThread {
        private final BluetoothSocket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;
        private final int maxPacketSize;
        private final int sleepTime;

        ConnectedThread(BluetoothSocket socket, String socketType) {
            super(BluetoothService.this);
            if (D) {
                Log.d((String)BluetoothService.TAG, (String)("create ConnectedThread: " + socketType));
            }
            if (Build.MODEL.equals("K012")) {
                this.maxPacketSize = 200;
                this.sleepTime = 40;
            } else {
                this.maxPacketSize = 500;
                this.sleepTime = 50;
            }
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"temp sockets not created", (Throwable)e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            if (D) {
                Log.i((String)BluetoothService.TAG, (String)"BEGIN mConnectedThread");
            }
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int bytes;
                    if ((bytes = this.mmInStream.read(buffer)) < 0) {
                        BluetoothService.this.connectionLost();
                        break;
                    }
                    if (D) {
                        Log.d((String)BluetoothService.TAG, (String)("[" + bytes + "] read(" + Utility.toHexString(Utility.copyOfRange(buffer, 0, bytes)) + ")"));
                    }
                    BluetoothService.this.mHandler.obtainMessage(2, bytes, -1, (Object)Utility.copyOfRange(buffer, 0, bytes)).sendToTarget();
                }
            }
            catch (IOException e) {
                if (D) {
                    Log.e((String)BluetoothService.TAG, (String)"disconnected", (Throwable)e);
                }
                BluetoothService.this.connectionLost();
            }
        }

        @Override
        void write(byte[] buffer) {
            try {
                if (buffer.length > this.maxPacketSize) {
                    int i = 0;
                    while (i < buffer.length) {
                        this.mmOutStream.write(buffer, i, i + this.maxPacketSize > buffer.length ? buffer.length - i : this.maxPacketSize);
                        try {
                            Thread.sleep(this.sleepTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        i += this.maxPacketSize;
                    }
                } else {
                    this.mmOutStream.write(buffer);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                BluetoothService.this.mHandler.obtainMessage(3, -1, -1, (Object)buffer).sendToTarget();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"Exception during write", (Throwable)e);
            }
        }

        @Override
        void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)BluetoothService.TAG, (String)"close() of connect socket failed", (Throwable)e);
            }
        }
    }
}

