/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.usb.UsbDevice;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.metapace.thermalprinter.print.BarCodeManager;
import com.metapace.thermalprinter.print.BitmapManager;
import com.metapace.thermalprinter.property.CodePageManager;
import com.metapace.thermalprinter.property.SecurityManager;
import com.metapace.thermalprinter.service.ServiceManager;
import com.metapace.thermalprinter.utility.Command;
import java.nio.ByteBuffer;

public class MetapacePrinter {
    public static final String TAG = MetapacePrinter.class.getSimpleName();
    public static boolean D = false;
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_TOAST = 5;
    public static final int MESSAGE_LOG = 6;
    public static final int MESSAGE_BLUETOOTH_DEVICE_SET = 7;
    public static final int MESSAGE_PRINT_COMPLETE = 8;
    public static final int MESSAGE_USB_DEVICE_SET = 10;
    public static final int MESSAGE_NETWORK_DEVICE_SET = 12;
    public static final int MESSAGE_ERROR_INVALID_ARGUMENT = 13;
    public static final int MESSAGE_ERROR_OUT_OF_MEMORY = 14;
    public static final int MESSAGE_ERROR_NV_MEMORY_CAPACITY = 15;
    public static final int STATE_NONE = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final String KEY_STRING_DEVICE_NAME = "device_name";
    public static final String KEY_STRING_TOAST = "toast";
    public static final String KEY_STRING_PRINTER_ID = "printer_id";
    public static final String KEY_STRING_DIRECT_IO = "direct_io";
    public static final String KEY_STRING_CODE_PAGE = "code_page";
    public static final String KEY_STRING_MONO_PIXELS = "mono_pixels";
    public static final String NV_IMAGE_KEY_CODES = "nv_image_key_codes";
    public static final String EXECUTE_DIRECT_IO = "EXECUTE_DIRECT_IO";
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int TEXT_ATTRIBUTE_FONT_A = 0;
    public static final int TEXT_ATTRIBUTE_FONT_B = 1;
    public static final int TEXT_ATTRIBUTE_FONT_C = 2;
    public static final int TEXT_ATTRIBUTE_UNDERLINE1 = 4;
    public static final int TEXT_ATTRIBUTE_UNDERLINE2 = 8;
    public static final int TEXT_ATTRIBUTE_EMPHASIZED = 16;
    public static final int TEXT_ATTRIBUTE_REVERSE = 32;
    public static final int TEXT_SIZE_HORIZONTAL1 = 0;
    public static final int TEXT_SIZE_HORIZONTAL2 = 16;
    public static final int TEXT_SIZE_HORIZONTAL3 = 32;
    public static final int TEXT_SIZE_HORIZONTAL4 = 48;
    public static final int TEXT_SIZE_HORIZONTAL5 = 64;
    public static final int TEXT_SIZE_HORIZONTAL6 = 80;
    public static final int TEXT_SIZE_HORIZONTAL7 = 96;
    public static final int TEXT_SIZE_HORIZONTAL8 = 112;
    public static final int TEXT_SIZE_VERTICAL1 = 0;
    public static final int TEXT_SIZE_VERTICAL2 = 1;
    public static final int TEXT_SIZE_VERTICAL3 = 2;
    public static final int TEXT_SIZE_VERTICAL4 = 3;
    public static final int TEXT_SIZE_VERTICAL5 = 4;
    public static final int TEXT_SIZE_VERTICAL6 = 5;
    public static final int TEXT_SIZE_VERTICAL7 = 6;
    public static final int TEXT_SIZE_VERTICAL8 = 7;
    public static final byte CODE_PAGE_437_USA = 0;
    public static final byte CODE_PAGE_KATAKANA = 1;
    public static final byte CODE_PAGE_850_MULTILINGUAL = 2;
    public static final byte CODE_PAGE_860_PORTUGUESE = 3;
    public static final byte CODE_PAGE_863_CANADIAN_FRENCH = 4;
    public static final byte CODE_PAGE_865_NORDIC = 5;
    public static final byte CODE_PAGE_1252_LATIN1 = 16;
    public static final byte CODE_PAGE_866_CYRILLIC2 = 17;
    public static final byte CODE_PAGE_852_LATIN2 = 18;
    public static final byte CODE_PAGE_858_EURO = 19;
    public static final byte CODE_PAGE_862_HEBREW_DOS_CODE = 21;
    public static final byte CODE_PAGE_864_ARABIC = 22;
    public static final byte CODE_PAGE_THAI42 = 23;
    public static final byte CODE_PAGE_1253_GREEK = 24;
    public static final byte CODE_PAGE_1254_TURKISH = 25;
    public static final byte CODE_PAGE_1257_BALTIC = 26;
    public static final byte CODE_PAGE_FARSI = 27;
    public static final byte CODE_PAGE_1251_CYRILLIC = 28;
    public static final byte CODE_PAGE_737_GREEK = 29;
    public static final byte CODE_PAGE_775_BALTIC = 30;
    public static final byte CODE_PAGE_THAI14 = 31;
    public static final byte CODE_PAGE_1255_HEBREW_NEW_CODE = 33;
    public static final byte CODE_PAGE_THAI11 = 34;
    public static final byte CODE_PAGE_THAI18 = 35;
    public static final byte CODE_PAGE_855_CYRILLIC = 36;
    public static final byte CODE_PAGE_857_TURKISH = 37;
    public static final byte CODE_PAGE_928_GREEK = 38;
    public static final byte CODE_PAGE_THAI16 = 39;
    public static final byte CODE_PAGE_1256_ARABIC = 40;
    public static final byte CODE_PAGE_1258_VIETNAM = 41;
    public static final byte CODE_PAGE_KHMER_CAMBODIA = 42;
    public static final byte CODE_PAGE_1250_CZECH = 47;
    public static final int BAR_CODE_UPC_A = 65;
    public static final int BAR_CODE_UPC_E = 66;
    public static final int BAR_CODE_EAN13 = 67;
    public static final int BAR_CODE_EAN8 = 68;
    public static final int BAR_CODE_CODE39 = 69;
    public static final int BAR_CODE_ITF = 70;
    public static final int BAR_CODE_CODABAR = 71;
    public static final int BAR_CODE_CODE93 = 72;
    public static final int BAR_CODE_CODE128 = 73;
    public static final int HRI_CHARACTER_NOT_PRINTED = 0;
    public static final int HRI_CHARACTERS_ABOVE_BAR_CODE = 1;
    public static final int HRI_CHARACTERS_BELOW_BAR_CODE = 2;
    public static final int HRI_CHARACTERS_ABOVE_AND_BELOW_BAR_CODE = 3;
    public static final int QR_CODE_MODEL1 = 49;
    public static final int QR_CODE_MODEL2 = 50;
    public static final int QR_CODE_ERROR_CORRECTION_LEVEL_L = 48;
    public static final int QR_CODE_ERROR_CORRECTION_LEVEL_M = 49;
    public static final int QR_CODE_ERROR_CORRECTION_LEVEL_Q = 50;
    public static final int QR_CODE_ERROR_CORRECTION_LEVEL_H = 51;
    public static final int PRINTER_ID_FIRMWARE_VERSION = 65;
    public static final int PRINTER_ID_MANUFACTURER = 66;
    public static final int PRINTER_ID_PRINTER_MODEL = 67;
    public static final int PRINTER_ID_CODE_PAGE = 69;
    public static final int STATUS_NORMAL = 0;
    public static final int STATUS_COVER_OPEN = 4;
    public static final int STATUS_PAPER_FED = 8;
    public static final int STATUS_PRINTING_STOPPED = 32;
    public static final int STATUS_ERROR_OCCURRED = 64;
    public static final int STATUS_PAPER_NEAR_END = 12;
    public static final int STATUS_PAPER_NOT_PRESENT = 96;
    public static final int BITMAP_WIDTH_FULL = -1;
    public static final int BITMAP_WIDTH_NONE = 0;
    public static final int AUTO_STATUS_OFF_LINE = 8;
    public static final int AUTO_STATUS_COVER_OPEN = 32;
    public static final int AUTO_STATUS_PAPER_FED = 64;
    public static final int AUTO_STATUS_UNRECOVERABLE_ERROR = 2;
    public static final int AUTO_STATUS_AUTO_RECOVERABLE_ERROR = 4;
    public static final int AUTO_STATUS_NO_PAPER = 12;
    public static final int DIRECTION_0_DEGREE_ROTATION = 0;
    public static final int DIRECTION_90_DEGREE_ROTATION = 1;
    public static final int DIRECTION_180_DEGREE_ROTATION = 2;
    public static final int DIRECTION_270_DEGREE_ROTATION = 3;
    public static final int DRAWER_CONNECTOR_PIN2 = 0;
    public static final int DRAWER_CONNECTOR_PIN5 = 1;
    public static final int PROCESS_NONE = 0;
    public static final int PROCESS_RESPONSE = 1;
    public static final int PROCESS_GET_STATUS = 2;
    public static final int PROCESS_GET_STATUS1 = 3;
    public static final int PROCESS_GET_STATUS2 = 4;
    public static final int PROCESS_GET_PRINTER_ID = 5;
    public static final int PROCESS_AUTO_STATUS_BACK = 6;
    public static final int PROCESS_EXECUTE_DIRECT_IO = 9;
    public static final int PROCESS_SET_SINGLE_BYTE_FONT = 10;
    public static final int PROCESS_GET_NV_IMAGE_KEY_CODES = 18;
    public static final int PROCESS_DEFINE_NV_IMAGE = 19;
    public static final int PROCESS_REMOVE_NV_IMAGE = 20;
    public static final int PROCESS_UPDATE_FIRMWARE = 21;
    public static final int PROCESS_CONNECTED = 22;
    public static final int PROCESS_KICK_OUT_CASH_DRAWER = 32;
    public static final int NV_IMAGE_MODE_NORMAL = 0;
    public static final int NV_IMAGE_MODE_DOUBLE_WIDTH = 1;
    public static final int NV_IMAGE_MODE_DOUBLE_HEIGHT = 2;
    public static final int NV_IMAGE_MODE_QUARDRUPLE = 3;
    private static final int MAX_BITMAP_SIZE = 196480;
    private static final int MAX_NV_GRAPHIC_SIZE = 65535;
    private ServiceManager mServiceManager;
    private boolean mIsPageMode;
    private Handler mApplicationHandler;

    public static void printLog(boolean print) {
        D = print;
    }

    public MetapacePrinter(Context context, Handler handler, Looper looper) {
        if (D) {
            Log.i((String)TAG, (String)"+++ METAPACE T-3II +++");
            Log.d((String)TAG, (String)("Build.VERSION.CODENAME: " + Build.VERSION.CODENAME + "\nBuild.VERSION.INCREMENTAL: " + Build.VERSION.INCREMENTAL + "\nBuild.VERSION.RELEASE: " + Build.VERSION.RELEASE + "\nBuild.VERSION.SDK_INT: " + Build.VERSION.SDK_INT + "\nBuild.BOARD: " + Build.BOARD + "\nBuild.BOOTLOADER: " + Build.BOOTLOADER + "\nBuild.BRAND: " + Build.BRAND + "\nBuild.CPU_ABI: " + Build.CPU_ABI + "\nBuild.CPU_ABI2: " + Build.CPU_ABI2 + "\nBuild.DEVICE: " + Build.DEVICE + "\nBuild.DISPLAY: " + Build.DISPLAY + "\nBuild.FINGERPRINT: " + Build.FINGERPRINT + "\nBuild.HARDWARE: " + Build.HARDWARE + "\nBuild.HOST: " + Build.HOST + "\nBuild.ID: " + Build.ID + "\nBuild.MANUFACTURER: " + Build.MANUFACTURER + "\nBuild.MODEL: " + Build.MODEL + "\nBuild.PRODUCT: " + Build.PRODUCT + "\nBuild.SERIAL: " + Build.SERIAL + "\nBuild.TAGS: " + Build.TAGS + "\nBuild.TIME: " + Build.TIME + "\nBuild.TYPE: " + Build.TYPE + "\nBuild.USER: " + Build.USER));
        }
        this.mApplicationHandler = handler;
        this.mServiceManager = new ServiceManager(this.hashCode(), context, handler, looper);
    }

    public void findBluetoothPrinters() {
        if (D) {
            Log.i((String)TAG, (String)"++ findBluetoothPrinters() ++");
        }
        this.mServiceManager.findBluetoothPrinters();
    }

    public void connect(String address) {
        if (D) {
            Log.i((String)TAG, (String)("++ connect(" + address + ") ++"));
        }
        this.mServiceManager.connect(address, false);
    }

    public void connect(String address, boolean secure) {
        if (D) {
            Log.i((String)TAG, (String)("++ connect(" + address + ", " + secure + ") ++"));
        }
        this.mServiceManager.connect(address, secure);
    }

    public void connect(String host, int port, int timeout) {
        if (D) {
            Log.i((String)TAG, (String)("++ connect(" + host + ", " + port + ", " + timeout + ") ++"));
        }
        this.mServiceManager.connect(host, port, timeout);
    }

    public void connect() {
        if (D) {
            Log.i((String)TAG, (String)"++ connect() ++");
        }
        this.mServiceManager.connect();
    }

    public void findUsbPrinters() {
        if (D) {
            Log.d((String)TAG, (String)"++ findUsbPrinters() ++");
        }
        this.mServiceManager.findUsbPrinters();
    }

    public void connect(UsbDevice device) {
        if (D) {
            Log.i((String)TAG, (String)("++ connect(" + device + ") ++"));
        }
        this.mServiceManager.connect(device);
    }

    public void findNetworkPrinters(int timeout) {
        this.mServiceManager.findNetworkPrinters(timeout);
    }

    public void disconnect() {
        if (D) {
            Log.i((String)TAG, (String)"++ disconnect() ++");
        }
        this.automateStatusBack(false);
        this.mServiceManager.disconnect();
    }

    public void getStatus() {
        if (D) {
            Log.i((String)TAG, (String)"++ getStatus() ++");
        }
        this.mServiceManager.executeCommand(3, 0);
    }

    public String getMacAddress() {
        if (D) {
            Log.i((String)TAG, (String)"++ getMacAddress() ++");
        }
        return this.mServiceManager.getMacAddress();
    }

    public void initialize() {
        if (D) {
            Log.i((String)TAG, (String)"++ initialize() ++");
        }
        this.mServiceManager.executeCommand(Command.INITIALIZATION, false);
    }

    public void executeDirectIo(byte[] command, boolean hasResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ directIo(" + command + ", " + hasResponse + ") ++"));
        }
        if (command != null && command.length != 0) {
            if (hasResponse) {
                this.mServiceManager.executeCommand(9, command);
            } else {
                this.mServiceManager.executeCommand(command, false);
            }
        }
    }

    public void printText(String text, int alignment, int attribute, int size, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ printText(" + text + ", " + alignment + ", " + attribute + ", " + size + ", " + getResponse + ") ++"));
        }
        if (text == null) {
            return;
        }
        byte[] bytes = CodePageManager.getBytes(text, this.mServiceManager.getCodePage());
        byte[] securityCode = null;
        int capacity = Command.ALIGNMENT_LEFT.length + Command.DEVICE_FONT_A.length + Command.UNDERLINE_OFF.length + Command.EMPHASIZED_OFF.length + Command.REVERSE_OFF.length + Command.CHARACTER_SIZE.length + 1 + bytes.length + 1;
        if (!this.mIsPageMode) {
            securityCode = SecurityManager.getSecurityCode();
            capacity += securityCode.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        if (!this.mIsPageMode) {
            buffer.put(securityCode);
        }
        if (alignment == 1) {
            buffer.put(Command.ALIGNMENT_CENTER);
        } else if (alignment == 2) {
            buffer.put(Command.ALIGNMENT_RIGHT);
        } else {
            buffer.put(Command.ALIGNMENT_LEFT);
        }
        if ((attribute & 1) == 1) {
            buffer.put(Command.DEVICE_FONT_B);
        } else if ((attribute & 2) == 2) {
            buffer.put(Command.DEVICE_FONT_C);
        } else {
            buffer.put(Command.DEVICE_FONT_A);
        }
        if ((attribute & 4) == 4) {
            buffer.put(Command.UNDERLINE_1DOT_THICK);
        } else if ((attribute & 8) == 8) {
            buffer.put(Command.UNDERLINE_2DOT_THICK);
        } else {
            buffer.put(Command.UNDERLINE_OFF);
        }
        if ((attribute & 0x10) == 16) {
            buffer.put(Command.EMPHASIZED_ON);
        } else {
            buffer.put(Command.EMPHASIZED_OFF);
        }
        if ((attribute & 0x20) == 32) {
            buffer.put(Command.REVERSE_ON);
        } else {
            buffer.put(Command.REVERSE_OFF);
        }
        buffer.put(Command.CHARACTER_SIZE);
        buffer.put((byte)size);
        buffer.put(bytes);
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void print1dBarcode(String data, int barCodeSystem, int alignment, int width, int height, int characterPosition, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ print1dBarcode(" + data + ", " + barCodeSystem + ", " + alignment + ", " + width + ", " + height + ", " + characterPosition + ") ++"));
        }
        if (data == null || data.length() == 0) {
            return;
        }
        switch (barCodeSystem) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                byte[] barCodeData = BarCodeManager.get1DBarCode(data.getBytes(), barCodeSystem, alignment, width, height, characterPosition);
                if (barCodeData == null) {
                    this.mApplicationHandler.obtainMessage(13, (Object)this.hashCode()).sendToTarget();
                    return;
                }
                int capacity = barCodeData.length;
                byte[] securityCode = null;
                if (!this.mIsPageMode) {
                    securityCode = SecurityManager.getSecurityCode();
                    capacity += securityCode.length;
                }
                ByteBuffer buffer = ByteBuffer.allocate(capacity);
                if (!this.mIsPageMode) {
                    buffer.put(securityCode);
                }
                buffer.put(barCodeData);
                this.mServiceManager.executeCommand(buffer.array(), getResponse);
            }
        }
    }

    public void printPdf417(String data, int alignment, int width, int height, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ printPdf417(" + data + ", " + alignment + ", " + width + ", " + height + ") ++"));
        }
        byte[] out = BarCodeManager.getPdf417(data.getBytes(), width, height);
        int capacity = Command.ALIGNMENT_LEFT.length + out.length;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        switch (alignment) {
            case 1: {
                buffer.put(Command.ALIGNMENT_CENTER);
                break;
            }
            case 2: {
                buffer.put(Command.ALIGNMENT_RIGHT);
                break;
            }
            default: {
                buffer.put(Command.ALIGNMENT_LEFT);
            }
        }
        buffer.put(out);
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void printQrCode(String data, int alignment, int model, int size, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ printQrCode(" + data + ", " + alignment + ", " + model + ", " + size + ", " + getResponse + ") ++"));
        }
        this.printQrCode(data, alignment, model, size, 48, getResponse);
    }

    public void printQrCode(String data, int alignment, int model, int size, int errorCorrectionLevel, boolean getResponse) {
        byte[] out;
        if (D) {
            Log.i((String)TAG, (String)("++ printQrCode(" + data + ", " + alignment + ", " + model + ", " + size + ", " + errorCorrectionLevel + ", " + getResponse + ") ++"));
        }
        if ((out = BarCodeManager.getQrCode(data.getBytes(), model, size, errorCorrectionLevel, 0)) == null) {
            this.mApplicationHandler.obtainMessage(13, (Object)this.hashCode()).sendToTarget();
            return;
        }
        int capacity = out.length;
        if (!this.mIsPageMode) {
            capacity += Command.ALIGNMENT_LEFT.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        if (!this.mIsPageMode) {
            switch (alignment) {
                case 1: {
                    buffer.put(Command.ALIGNMENT_CENTER);
                    break;
                }
                case 2: {
                    buffer.put(Command.ALIGNMENT_RIGHT);
                    break;
                }
                default: {
                    buffer.put(Command.ALIGNMENT_LEFT);
                }
            }
        }
        buffer.put(out);
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void printDataMatrix(String data, int alignment, int size, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ printDataMatrix(" + data + ", " + alignment + ", " + size + ") ++"));
        }
        byte[] out = BarCodeManager.getDataMatrix(data.getBytes(), size);
        int capacity = Command.ALIGNMENT_LEFT.length + out.length;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        switch (alignment) {
            case 1: {
                buffer.put(Command.ALIGNMENT_CENTER);
                break;
            }
            case 2: {
                buffer.put(Command.ALIGNMENT_RIGHT);
                break;
            }
            default: {
                buffer.put(Command.ALIGNMENT_LEFT);
            }
        }
        buffer.put(out);
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void lineFeed(int lines, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ lineFeed(" + lines + ", " + getResponse + ") ++"));
        }
        ByteBuffer buffer = ByteBuffer.allocate(lines);
        int i = 0;
        while (i < lines) {
            buffer.put(Command.LINE_FEED);
            ++i;
        }
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void cutPaper(int feeds, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ cutPaper(" + feeds + ", " + getResponse + ") ++"));
        }
        int capacity = Command.PARTIAL_CUT.length + 1;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.PARTIAL_CUT);
        if (feeds < 0 || feeds > 255) {
            feeds = 0;
        }
        buffer.put((byte)feeds);
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void cutPaper(boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ cutPaper(" + getResponse + ") ++"));
        }
        this.mServiceManager.executeCommand(Command.PARTIAL_CUT_NO_FEED, getResponse);
    }

    public void printBitmap(String pathName, int alignment, int width, int level, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ printBitmap(" + pathName + ", " + alignment + ", " + width + ", " + level + ") ++"));
        }
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = false;
        opts.inSampleSize = 1;
        opts.inPreferredConfig = Bitmap.Config.RGB_565;
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
            this.printBitmap(bitmap, alignment, width, level, getResponse);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            this.mApplicationHandler.obtainMessage(14, (Object)this.hashCode()).sendToTarget();
        }
    }

    public void printBitmap(Bitmap bitmap, int alignment, int width, int level, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ printBitmap(" + bitmap + ", " + alignment + ", " + width + ", " + level + ") ++"));
        }
        if (bitmap == null) {
            return;
        }
        int MAX_WIDTH = this.mServiceManager.getMaxWidth();
        if (width == -1) {
            width = MAX_WIDTH;
        } else if (width == 0 || width < 0) {
            width = bitmap.getWidth();
        }
        if (width > MAX_WIDTH) {
            width = MAX_WIDTH;
        }
        byte[] printerData = null;
        try {
            printerData = BitmapManager.bitmap2printerData(bitmap, width, level, 0);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)e.toString());
            this.mApplicationHandler.obtainMessage(14, (Object)this.hashCode()).sendToTarget();
            return;
        }
        if (printerData.length > 196480) {
            this.mApplicationHandler.obtainMessage(15, (Object)this.hashCode()).sendToTarget();
            return;
        }
        int height = BitmapManager.getBitmapHeight(bitmap, width);
        int capacity = Command.ALIGNMENT_LEFT.length + Command.RASTER_BIT_IMAGE_NORMAL.length + 4 + printerData.length;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        switch (alignment) {
            case 1: {
                buffer.put(Command.ALIGNMENT_CENTER);
                break;
            }
            case 2: {
                buffer.put(Command.ALIGNMENT_RIGHT);
                break;
            }
            default: {
                buffer.put(Command.ALIGNMENT_LEFT);
            }
        }
        buffer.put(Command.RASTER_BIT_IMAGE_NORMAL);
        int widthBytes = BitmapManager.bytesOfWidth(width);
        buffer.put((byte)(widthBytes % 256));
        buffer.put((byte)(widthBytes / 256));
        buffer.put((byte)(height % 256));
        buffer.put((byte)(height / 256));
        buffer.put(printerData);
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void kickOutDrawer(int connectorPin) {
        if (D) {
            Log.i((String)TAG, (String)("++ kickOutDrawer(" + connectorPin + ") ++"));
        }
        this.mServiceManager.executeCommand(32, connectorPin);
    }

    public void defineNvImage(NvImageOptions[] options) {
        if (D) {
            Log.i((String)TAG, (String)("++ defineNvImage(" + options + ") ++"));
        }
        if (options == null || options.length == 0) {
            return;
        }
        byte[][] datas = new byte[options.length][];
        int i = 0;
        while (i < options.length) {
            Bitmap bitmap = null;
            if (options[i].pathName != null) {
                BitmapFactory.Options opts = new BitmapFactory.Options();
                opts.inJustDecodeBounds = false;
                opts.inSampleSize = 1;
                opts.inPreferredConfig = Bitmap.Config.RGB_565;
                bitmap = BitmapFactory.decodeFile((String)options[i].pathName, (BitmapFactory.Options)opts);
            } else if (options[i].bitmap != null) {
                bitmap = options[i].bitmap;
            } else {
                return;
            }
            int MAX_WIDTH = this.mServiceManager.getMaxWidth();
            int width = options[i].width;
            if (options[i].width == -1) {
                width = MAX_WIDTH;
            } else if (options[i].width == 0 || options[i].width < 0) {
                width = bitmap.getWidth();
            }
            if (width > MAX_WIDTH) {
                width = MAX_WIDTH;
            }
            try {
                datas[i] = BitmapManager.bitmap2printerData(bitmap, width, options[i].level, 8);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)e.toString());
                this.mApplicationHandler.obtainMessage(14, (Object)this.hashCode()).sendToTarget();
                return;
            }
            int height = BitmapManager.getBitmapHeight(bitmap, width);
            if (D) {
                Log.d((String)TAG, (String)("data.length: " + datas[i].length + ", width: " + width + ", height: " + height));
            }
            ++i;
        }
        int capacity = Command.FS_DEFINE_NV_IMAGE.length + 1;
        int i2 = 0;
        while (i2 < datas.length) {
            capacity += datas[i2].length;
            ++i2;
        }
        if (capacity > 131072) {
            this.mApplicationHandler.obtainMessage(15, (Object)this.hashCode()).sendToTarget();
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.FS_DEFINE_NV_IMAGE);
        buffer.put((byte)datas.length);
        int i3 = 0;
        while (i3 < datas.length) {
            buffer.put(datas[i3]);
            ++i3;
        }
        this.mServiceManager.executeCommand(19, buffer.array());
    }

    public void printNvImage(int keyCode, int mode, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ printNvImage(" + keyCode + ", " + mode + ", " + getResponse + ") ++"));
        }
        int capacity = Command.FS_PRINT_NV_IMAGE.length + 2;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.FS_PRINT_NV_IMAGE);
        buffer.put((byte)keyCode);
        buffer.put((byte)mode);
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void defineNvImage(String pathName, int width, int level, int keyCode) {
        if (D) {
            Log.i((String)TAG, (String)("++ defineNvImage(" + pathName + ", " + width + ", " + level + ", " + keyCode + ") ++"));
        }
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = false;
        opts.inSampleSize = 1;
        opts.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bitmap = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
        this.defineNvImage(bitmap, width, level, keyCode);
    }

    public void defineNvImage(Bitmap bitmap, int width, int level, int keyCode) {
        if (D) {
            Log.i((String)TAG, (String)("++ defineNvImage(" + bitmap + ", " + width + ", " + level + ", " + keyCode + ") ++"));
        }
        if (bitmap == null) {
            return;
        }
        int MAX_WIDTH = this.mServiceManager.getMaxWidth();
        if (width == -1) {
            width = MAX_WIDTH;
        } else if (width == 0 || width < 0) {
            width = bitmap.getWidth();
        }
        if (width > MAX_WIDTH) {
            width = MAX_WIDTH;
        }
        byte[] data = null;
        try {
            data = BitmapManager.bitmap2printerData(bitmap, width, level, 0);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)e.toString());
            this.mApplicationHandler.obtainMessage(14, (Object)this.hashCode()).sendToTarget();
            return;
        }
        if (data.length > 65535) {
            this.mApplicationHandler.obtainMessage(15, (Object)this.hashCode()).sendToTarget();
            return;
        }
        int height = BitmapManager.getBitmapHeight(bitmap, width);
        if (D) {
            Log.d((String)TAG, (String)("data.length: " + data.length + ", width: " + width + ", height: " + height));
        }
        int capacity = Command.NV_IMAGE_DEFINITION.length + 2 + Command.NV_IMAGE_DEFINITION_FUNCTION.length + 2 + 1 + 4 + 1 + data.length;
        if (D) {
            Log.d((String)TAG, (String)("capacity: " + capacity));
        }
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.NV_IMAGE_DEFINITION);
        buffer.put((byte)((capacity - 5) % 256));
        buffer.put((byte)((capacity - 5) / 256));
        buffer.put(Command.NV_IMAGE_DEFINITION_FUNCTION);
        buffer.put((byte)(keyCode / 10 + 48));
        buffer.put((byte)(keyCode % 10 + 48));
        buffer.put((byte)1);
        buffer.put((byte)(width % 256));
        buffer.put((byte)(width / 256));
        buffer.put((byte)(height % 256));
        buffer.put((byte)(height / 256));
        buffer.put((byte)49);
        buffer.put(data);
        this.mServiceManager.executeCommand(19, buffer.array());
    }

    public void printNvImage(int keyCode, boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ printNvImage(" + keyCode + ", " + getResponse + ") ++"));
        }
        int capacity = Command.NV_IMAGE_PRINT.length + 2 + Command.NV_IMAGE_PRINT_FOOTER.length;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.NV_IMAGE_PRINT);
        buffer.put((byte)(keyCode / 10 + 48));
        buffer.put((byte)(keyCode % 10 + 48));
        buffer.put(Command.NV_IMAGE_PRINT_FOOTER);
        this.mServiceManager.executeCommand(buffer.array(), getResponse);
    }

    public void removeNvImage(int keyCode) {
        if (D) {
            Log.i((String)TAG, (String)("++ removeNvImage(" + keyCode + ") ++"));
        }
        int capacity = Command.NV_IMAGE_REMOVAL.length + 2;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.NV_IMAGE_REMOVAL);
        buffer.put((byte)(keyCode / 10 + 48));
        buffer.put((byte)(keyCode % 10 + 48));
        this.mServiceManager.executeCommand(20, buffer.array());
    }

    public void removeAllNvImage() {
        if (D) {
            Log.i((String)TAG, (String)"++ removeAllNvImage() ++");
        }
        this.mServiceManager.executeCommand(20, Command.NV_IMAGE_ALL_REMOVAL);
    }

    public void getDefinedNvImageKeyCodes() {
        if (D) {
            Log.i((String)TAG, (String)"++ getDefinedNvImageKeyCodes() ++");
        }
        this.mServiceManager.executeCommand(18, 0);
    }

    public void setSingleByteFont(int codePage) {
        if (D) {
            Log.i((String)TAG, (String)("++ setSingleByteFont(" + codePage + ") ++"));
        }
        this.mServiceManager.executeCommand(10, codePage);
    }

    public void getPrinterId(int idType) {
        if (D) {
            Log.i((String)TAG, (String)("++ getPrinterId(" + idType + ") ++"));
        }
        this.mServiceManager.executeCommand(5, idType);
    }

    public void automateStatusBack(boolean isEnable) {
        if (D) {
            Log.i((String)TAG, (String)("++ automateStatusBack(" + isEnable + ") ++"));
        }
        if (isEnable) {
            this.mServiceManager.executeCommand(Command.ENABLE_ASB, false);
        } else {
            this.mServiceManager.executeCommand(Command.DISABLE_ASB, false);
        }
    }

    public void formFeed(boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)("++ formFeed(" + getResponse + ") ++"));
        }
        if (this.mIsPageMode) {
            this.mIsPageMode = false;
        }
        this.mServiceManager.executeCommand(Command.FORM_FEED, getResponse);
    }

    public void setPageMode() {
        if (D) {
            Log.i((String)TAG, (String)"++ setPageMode() ++");
        }
        this.mIsPageMode = true;
        this.mServiceManager.executeCommand(Command.PAGE_MODE, false);
    }

    public void setStandardMode() {
        if (D) {
            Log.i((String)TAG, (String)"++ setStandardMode() ++");
        }
        this.mIsPageMode = false;
        this.mServiceManager.executeCommand(Command.STANDARD_MODE, false);
    }

    public void setPrintArea(int x, int y, int width, int height) {
        if (D) {
            Log.i((String)TAG, (String)("++ setPrintArea(" + x + ", " + y + ", " + width + ", " + height + ") ++"));
        }
        if (this.mIsPageMode) {
            int capacity = Command.PRINT_AREA.length + 8;
            ByteBuffer buffer = ByteBuffer.allocate(capacity);
            buffer.put(Command.PRINT_AREA);
            buffer.put((byte)(x % 256));
            buffer.put((byte)(x / 256));
            buffer.put((byte)(y % 256));
            buffer.put((byte)(y / 256));
            buffer.put((byte)(width % 256));
            buffer.put((byte)(width / 256));
            buffer.put((byte)(height % 256));
            buffer.put((byte)(height / 256));
            this.mServiceManager.executeCommand(buffer.array(), false);
        }
    }

    public void setPrintDirection(int direction) {
        if (D) {
            Log.i((String)TAG, (String)("++ setPrintDirection(" + direction + ") ++"));
        }
        if (this.mIsPageMode) {
            switch (direction) {
                case 1: {
                    this.mServiceManager.executeCommand(Command.PRINT_DIRECION_BOTTOM_TO_TOP, false);
                    break;
                }
                case 2: {
                    this.mServiceManager.executeCommand(Command.PRINT_DIRECION_RIGHT_TO_LEFT, false);
                    break;
                }
                case 3: {
                    this.mServiceManager.executeCommand(Command.PRINT_DIRECION_TOP_TO_BOTTOM, false);
                    break;
                }
                default: {
                    this.mServiceManager.executeCommand(Command.PRINT_DIRECION_LEFT_TO_RIGHT, false);
                }
            }
        }
    }

    public void setAbsolutePrintPosition(int position) {
        if (D) {
            Log.i((String)TAG, (String)("++ setAbsolutePrintPosition(" + position + ") ++"));
        }
        int capacity = Command.ABSOLUTE_POSITION.length + 2;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(Command.ABSOLUTE_POSITION);
        buffer.put((byte)(position % 256));
        buffer.put((byte)(position / 256));
        this.mServiceManager.executeCommand(buffer.array(), false);
    }

    public void setAbsoluteVerticalPrintPosition(int position) {
        if (D) {
            Log.i((String)TAG, (String)("++ setAbsoluteVerticalPrintPosition(" + position + ") ++"));
        }
        if (this.mIsPageMode) {
            int capacity = Command.ABSOLUTE_VERTICAL_POSITION.length + 2;
            ByteBuffer buffer = ByteBuffer.allocate(capacity);
            buffer.put(Command.ABSOLUTE_VERTICAL_POSITION);
            buffer.put((byte)(position % 256));
            buffer.put((byte)(position / 256));
            this.mServiceManager.executeCommand(buffer.array(), false);
        }
    }

    public void updateFirmware(String binaryFilePath) {
        if (D) {
            Log.i((String)TAG, (String)("++ updateFirmware(" + binaryFilePath + ") ++"));
        }
        this.mServiceManager.executeCommand(21, binaryFilePath.getBytes());
    }

    public void printSelfTest(boolean getResponse) {
        if (D) {
            Log.i((String)TAG, (String)"++ printSelfTest ++");
        }
        this.mServiceManager.executeCommand(Command.SELF_TEST, getResponse);
    }

    public static class NvImageOptions {
        String pathName;
        Bitmap bitmap;
        int width;
        int level;

        public NvImageOptions(String pathName, int width, int level) {
            this.pathName = pathName;
            this.width = width;
            this.level = level;
        }

        public NvImageOptions(Bitmap bitmap, int width, int level) {
            this.bitmap = bitmap;
            this.width = width;
            this.level = level;
        }

        public String toString() {
            return super.toString();
        }
    }
}

