/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.connectivity;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.metapace.thermalprinter.connectivity.ConnectivityService;
import com.metapace.thermalprinter.utility.Utility;

public final class UsbService
extends ConnectivityService {
    private static final String TAG = "UsbService";
    static final int PRINTER_INTERFACE_CLASS = 7;
    static final int PRINTER_INTERFACE_SUBCLASS = 1;
    static final int PRINTER_INTERFACE_PROTOCOL = 2;

    UsbService(Handler handler) {
        super(handler);
    }

    synchronized String getSerial() {
        if (this.mConnectedThread != null) {
            return ((ConnectedThread)this.mConnectedThread).getSerial();
        }
        return null;
    }

    synchronized void connect(UsbManager manager, UsbDevice device, String serial) {
        if (D) {
            Log.d((String)TAG, (String)"connect");
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(manager, device, serial);
        this.mConnectThread.start();
        this.setState(1);
    }

    synchronized void connected(UsbDevice device, UsbDeviceConnection deviceConnection, UsbInterface intf) {
        if (D) {
            Log.d((String)TAG, (String)"connected");
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectedThread = new ConnectedThread(device, deviceConnection, intf);
        this.mConnectedThread.start();
        Message msg = this.mHandler.obtainMessage(4);
        Bundle bundle = new Bundle();
        bundle.putString("device_name", device.getDeviceName());
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.setState(2);
    }

    private class ConnectThread
    extends ConnectivityService.ConnectThread {
        UsbManager mmManager;
        UsbDevice mmDevice;
        UsbDeviceConnection mmDeviceConnection;
        UsbInterface mmInterface;
        String mmSerial;

        ConnectThread(UsbManager manager, UsbDevice device, String serial) {
            super(UsbService.this);
            this.mmManager = manager;
            this.mmDevice = device;
            this.mmSerial = serial;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (D) {
                Log.i((String)UsbService.TAG, (String)"BEGIN mConnectThread");
            }
            this.setName("ConnectThread");
            if (this.mmDevice != null) {
                UsbInterface intf = this.findUsbInterface(this.mmDevice);
                this.setUsbInterface(this.mmDevice, intf);
            } else {
                int i = 0;
                for (UsbDevice device : this.mmManager.getDeviceList().values()) {
                    UsbInterface intf;
                    if (D) {
                        Log.d((String)UsbService.TAG, (String)("[" + i++ + "] UsbDevice: " + device.toString()));
                    }
                    if (this.setUsbInterface(device, intf = this.findUsbInterface(device))) break;
                }
            }
            if (this.mmDevice == null || this.mmDeviceConnection == null || this.mmInterface == null) {
                UsbService.this.connectionFailed();
                return;
            }
            UsbService usbService = UsbService.this;
            synchronized (usbService) {
                UsbService.this.mConnectThread = null;
            }
            UsbService.this.connected(this.mmDevice, this.mmDeviceConnection, this.mmInterface);
        }

        @Override
        void cancel() {
            this.setUsbInterface(null, null);
        }

        private UsbInterface findUsbInterface(UsbDevice device) {
            if (D) {
                Log.d((String)UsbService.TAG, (String)("findUsbInterface " + device));
            }
            int count = device.getInterfaceCount();
            int i = 0;
            while (i < count) {
                UsbInterface intf = device.getInterface(i);
                if (D) {
                    Log.d((String)UsbService.TAG, (String)("[" + i + "] UsbInterface: " + intf.toString()));
                }
                if (intf.getInterfaceClass() == 7 && intf.getInterfaceSubclass() == 1 && intf.getInterfaceProtocol() == 2) {
                    return intf;
                }
                ++i;
            }
            return null;
        }

        private synchronized boolean setUsbInterface(UsbDevice device, UsbInterface intf) {
            if (D) {
                Log.d((String)UsbService.TAG, (String)("setUsbInterface( " + device + ", " + intf + ")"));
            }
            if (this.mmDeviceConnection != null) {
                if (this.mmInterface != null) {
                    this.mmDeviceConnection.releaseInterface(this.mmInterface);
                    this.mmInterface = null;
                }
                this.mmDeviceConnection.close();
                this.mmDevice = null;
                this.mmDeviceConnection = null;
            }
            if (device != null && intf != null) {
                UsbDeviceConnection connection = this.mmManager.openDevice(device);
                if (connection != null && (this.mmSerial == null || connection.getSerial().equals(this.mmSerial))) {
                    if (D) {
                        Log.d((String)UsbService.TAG, (String)"open succeeded");
                    }
                    if (connection.claimInterface(intf, true)) {
                        this.mmDevice = device;
                        if (D) {
                            Log.d((String)UsbService.TAG, (String)("/********** UsbDevice **********/\nDeviceClass: " + this.mmDevice.getDeviceClass() + "\nDeviceID: " + this.mmDevice.getDeviceId() + "\nDeviceName: " + this.mmDevice.getDeviceName() + "\nDeviceProtocol: " + this.mmDevice.getDeviceProtocol() + "\nDeviceSubclass: " + this.mmDevice.getDeviceSubclass() + "\nInterfaceCount: " + this.mmDevice.getInterfaceCount() + "\nProduceId: " + this.mmDevice.getProductId() + "\nVendorId: " + this.mmDevice.getVendorId() + "\n/******************************/\n"));
                        }
                        this.mmDeviceConnection = connection;
                        if (D) {
                            Log.d((String)UsbService.TAG, (String)("/********** UsbDeviceConnection **********/\nFileDescriptor: " + this.mmDeviceConnection.getFileDescriptor() + "\nSerial: " + this.mmDeviceConnection.getSerial() + "\n/******************************/\n"));
                        }
                        this.mmInterface = intf;
                        if (D) {
                            Log.d((String)UsbService.TAG, (String)("/********** UsbInterface **********/\nEndpointCount: " + this.mmInterface.getEndpointCount() + "\nId: " + this.mmInterface.getId() + "\nInterfaceClass: " + this.mmInterface.getInterfaceClass() + "\nInterfaceProtocol: " + this.mmInterface.getInterfaceProtocol() + "\nInterfaceSubClass: " + this.mmInterface.getInterfaceSubclass() + "\n/******************************/\n"));
                        }
                        if (D) {
                            Log.d((String)UsbService.TAG, (String)"call start");
                        }
                        return true;
                    }
                    if (D) {
                        Log.d((String)UsbService.TAG, (String)"claim interface failed");
                    }
                    UsbService.this.connectionFailed();
                    connection.close();
                } else {
                    if (D) {
                        Log.d((String)UsbService.TAG, (String)"open failed");
                    }
                    UsbService.this.connectionFailed();
                }
            }
            return false;
        }
    }

    private class ConnectedThread
    extends ConnectivityService.ConnectedThread {
        final int TIMEOUT = 0;
        final int MAX_PACKET_SIZE = 16384;
        UsbDeviceConnection mmDeviceConnection;
        UsbInterface mmInterface;
        final UsbEndpoint mmEndpointOut;
        final UsbEndpoint mmEndpointIn;
        String mmSerial;

        ConnectedThread(UsbDevice device, UsbDeviceConnection connection, UsbInterface intf) {
            super(UsbService.this);
            this.TIMEOUT = 0;
            this.MAX_PACKET_SIZE = 16384;
            if (D) {
                Log.d((String)UsbService.TAG, (String)"create ConnectedThread");
            }
            this.mmDeviceConnection = connection;
            this.mmInterface = intf;
            this.mmSerial = connection.getSerial();
            UsbEndpoint epOut = null;
            UsbEndpoint epIn = null;
            int i = 0;
            while (i < this.mmInterface.getEndpointCount()) {
                UsbEndpoint ep = this.mmInterface.getEndpoint(i);
                if (ep.getType() == 2) {
                    if (ep.getDirection() == 0) {
                        epOut = ep;
                    } else {
                        epIn = ep;
                    }
                }
                ++i;
            }
            if (epOut == null || epIn == null) {
                throw new IllegalArgumentException("not all endpoints found");
            }
            this.mmEndpointOut = epOut;
            this.mmEndpointIn = epIn;
            if (D) {
                Log.d((String)UsbService.TAG, (String)("device online: " + this.getSerial() + "\n" + "/********** UsbEndpoint (USB_DIR_OUT) **********/" + "\nAddress: " + this.mmEndpointOut.getAddress() + "\nAttributes: " + this.mmEndpointOut.getAttributes() + "\nDirection: " + this.mmEndpointOut.getDirection() + "\nEndpointNumber: " + this.mmEndpointOut.getEndpointNumber() + "\nInterval: " + this.mmEndpointOut.getInterval() + "\nMaxPacketSize: " + this.mmEndpointOut.getMaxPacketSize() + "\nType: " + this.mmEndpointOut.getType() + "\n/******************************/\n" + "\n/********** UsbEndpoint (USB_DIR_IN) **********/" + "\nAddress: " + this.mmEndpointIn.getAddress() + "\nAttributes: " + this.mmEndpointIn.getAttributes() + "\nDirection: " + this.mmEndpointIn.getDirection() + "\nEndpointNumber: " + this.mmEndpointIn.getEndpointNumber() + "\nInterval: " + this.mmEndpointIn.getInterval() + "\nMaxPacketSize: " + this.mmEndpointIn.getMaxPacketSize() + "\nType: " + this.mmEndpointIn.getType() + "\n/******************************/\n"));
            }
        }

        String getSerial() {
            return this.mmSerial;
        }

        @Override
        public void run() {
            if (D) {
                Log.i((String)UsbService.TAG, (String)"BEGIN mConnectedThread");
            }
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int bytes;
                    if ((bytes = this.mmDeviceConnection.bulkTransfer(this.mmEndpointIn, buffer, buffer.length, 0)) < 0) {
                        if (D) {
                            Log.d((String)UsbService.TAG, (String)("[" + bytes + "] bulkTransfer(" + this.mmEndpointIn + ", " + Utility.toHexString(buffer) + ", " + buffer.length + ", " + 0 + ")"));
                        }
                        UsbService.this.connectionLost();
                        break;
                    }
                    if (bytes <= 0) continue;
                    if (D) {
                        Log.d((String)UsbService.TAG, (String)("[" + bytes + "] bulkTransfer(" + this.mmEndpointIn + ", " + Utility.toHexString(Utility.copyOfRange(buffer, 0, bytes)) + ", " + buffer.length + ", " + 0 + ")"));
                    }
                    UsbService.this.mHandler.obtainMessage(2, bytes, -1, (Object)Utility.copyOfRange(buffer, 0, bytes)).sendToTarget();
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                Log.e((String)UsbService.TAG, (String)"disconnected");
                UsbService.this.connectionLost();
            }
        }

        @Override
        void write(byte[] buffer) {
            int transferedBytes = 0;
            while (transferedBytes < buffer.length) {
                int length = buffer.length - transferedBytes > 16384 ? 16384 : buffer.length - transferedBytes;
                byte[] b = Utility.copyOfRange(buffer, transferedBytes, transferedBytes + length);
                int bytes = this.mmDeviceConnection.bulkTransfer(this.mmEndpointOut, b, length, 0);
                if (D) {
                    Log.d((String)UsbService.TAG, (String)("[" + bytes + "] bulkTransfer(" + this.mmEndpointOut + ", " + Utility.toHexString(b) + ", " + length + ", " + 0 + ")"));
                }
                if (bytes < 0) {
                    if (D) {
                        Log.d((String)UsbService.TAG, (String)"Exception during write");
                    }
                    UsbService.this.connectionLost();
                    break;
                }
                transferedBytes += bytes;
            }
            UsbService.this.mHandler.obtainMessage(3, -1, -1, (Object)buffer).sendToTarget();
        }

        @Override
        void cancel() {
            if (D) {
                Log.d((String)UsbService.TAG, (String)"UsbService.ConnectThread.cancel()");
            }
            if (this.mmDeviceConnection != null) {
                if (this.mmInterface != null) {
                    this.mmDeviceConnection.releaseInterface(this.mmInterface);
                    this.mmInterface = null;
                }
                this.mmDeviceConnection.close();
                this.mmDeviceConnection = null;
            }
        }
    }
}

