/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.connectivity;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.metapace.thermalprinter.MetapacePrinter;
import com.metapace.thermalprinter.connectivity.BluetoothService;
import com.metapace.thermalprinter.connectivity.BroadcastThread;
import com.metapace.thermalprinter.connectivity.NetworkService;
import com.metapace.thermalprinter.connectivity.UsbService;
import com.metapace.thermalprinter.service.PrinterHandler;
import com.metapace.thermalprinter.utility.Utility;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class ConnectivityManager {
    private static final String TAG = "ConnectivityManager";
    private static final boolean D = MetapacePrinter.D;
    private BluetoothAdapter mBluetoothAdapter = null;
    private BluetoothService mBluetoothService = null;
    private NetworkService mNetworkService = null;
    private UsbService mUsbService = null;
    private Handler mHandler;
    private Context mContext;
    private String mAddress;
    private BroadcastThread mBroadcastThread;
    private Connectivity mConnectivity;

    public ConnectivityManager(Context context, PrinterHandler handler) {
        this.mContext = context;
        this.mHandler = handler;
        this.mConnectivity = Connectivity.CONNECT_NONE;
    }

    public void connect(String address, boolean secure) {
        if (D) {
            Log.d((String)TAG, (String)"++ CONNECT (BLUETOOTH) ++");
        }
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            Message msg = this.mHandler.obtainMessage(5);
            Bundle bundle = new Bundle();
            bundle.putString("toast", "Bluetooth is not available");
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
            return;
        }
        if (this.mBluetoothAdapter.isEnabled()) {
            if (this.mBluetoothService == null) {
                this.mBluetoothService = new BluetoothService(this.mHandler);
            }
            if (this.mBluetoothService != null && this.mBluetoothService.getState() == 0) {
                this.mConnectivity = Connectivity.CONNECT_BLUETOOTH;
                this.connectDevice(address, secure);
            }
        }
    }

    public void connect(String host, int port, int timeout) {
        if (D) {
            Log.d((String)TAG, (String)"++ CONNECT (Network) ++");
        }
        if (this.mNetworkService != null) {
            this.mNetworkService.stop();
            this.mNetworkService = null;
        }
        this.mNetworkService = new NetworkService(this.mHandler);
        if (this.mNetworkService.getState() == 0) {
            this.mConnectivity = Connectivity.CONNECT_NETWORK;
            this.mAddress = host;
            this.mNetworkService.connect(host, port, timeout);
        }
    }

    public void connect() {
        if (D) {
            Log.d((String)TAG, (String)"++ CONNECT (USB) ++");
        }
        if (Build.VERSION.SDK_INT >= 12) {
            if (this.mUsbService == null) {
                this.mUsbService = new UsbService(this.mHandler);
            }
            if (this.mUsbService != null) {
                this.mConnectivity = Connectivity.CONNECT_USB;
                this.mUsbService.connect((UsbManager)this.mContext.getSystemService("usb"), null, null);
            }
        }
    }

    public void connect(UsbDevice device) {
        if (D) {
            Log.d((String)TAG, (String)"++ CONNECT (USB) ++");
        }
        if (Build.VERSION.SDK_INT >= 12) {
            if (this.mUsbService == null) {
                this.mUsbService = new UsbService(this.mHandler);
            }
            if (this.mUsbService != null) {
                this.mConnectivity = Connectivity.CONNECT_USB;
                this.mUsbService.connect((UsbManager)this.mContext.getSystemService("usb"), device, null);
            }
        }
    }

    public void disconnect() {
        switch (this.mConnectivity) {
            case CONNECT_BLUETOOTH: {
                if (this.mBluetoothService == null) break;
                this.mBluetoothService.stop();
                this.mBluetoothService = null;
                break;
            }
            case CONNECT_NETWORK: {
                if (this.mNetworkService == null) break;
                this.mNetworkService.stop();
                this.mNetworkService = null;
                break;
            }
            case CONNECT_USB: {
                if (this.mUsbService == null) break;
                this.mUsbService.stop();
                this.mUsbService = null;
                break;
            }
        }
        this.mConnectivity = Connectivity.CONNECT_NONE;
        this.mAddress = null;
        if (D) {
            Log.d((String)TAG, (String)"-- DISCONNECT --");
        }
    }

    public void findBluetoothPrinters() {
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            Message msg = this.mHandler.obtainMessage(5);
            Bundle bundle = new Bundle();
            bundle.putString("toast", "Bluetooth is not available");
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
            return;
        }
        if (!this.mBluetoothAdapter.isEnabled()) {
            Message msg = this.mHandler.obtainMessage(5);
            Bundle bundle = new Bundle();
            bundle.putString("toast", "Requested that Bluetooth be enabled");
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
            return;
        }
        Set pairedDevices = this.mBluetoothAdapter.getBondedDevices();
        HashSet<BluetoothDevice> pairedPrinters = new HashSet<BluetoothDevice>();
        if (pairedDevices.size() > 0) {
            for (BluetoothDevice device : pairedDevices) {
                String deviceAddress = device.getAddress();
                if (!this.checkMacAddressPrefixes(deviceAddress)) continue;
                pairedPrinters.add(device);
            }
        }
        if (pairedPrinters.size() > 0) {
            this.mHandler.obtainMessage(7, pairedPrinters).sendToTarget();
        } else {
            this.mHandler.obtainMessage(7, null).sendToTarget();
        }
    }

    private void connectDevice(String address, boolean secure) {
        if (address == null) {
            Set pairedDevices = this.mBluetoothAdapter.getBondedDevices();
            if (pairedDevices.size() > 0) {
                for (BluetoothDevice device : pairedDevices) {
                    String deviceAddress = device.getAddress();
                    if (!this.checkMacAddressPrefixes(deviceAddress)) continue;
                    this.mBluetoothService.connect(device, secure);
                    break;
                }
            }
        } else {
            BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(address.toUpperCase(Locale.getDefault()));
            if (this.checkMacAddressPrefixes(device.getAddress())) {
                this.mBluetoothService.connect(device, secure);
            } else {
                this.mHandler.obtainMessage(13, null).sendToTarget();
            }
        }
    }

    private boolean checkMacAddressPrefixes(String macAddress) {
        String[] stringArray = BluetoothService.MAC_ADDRESS_PREFIXES;
        int n = BluetoothService.MAC_ADDRESS_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (macAddress.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void findUsbPrinters() {
        UsbManager usbManager = (UsbManager)this.mContext.getSystemService("usb");
        HashSet<UsbDevice> usbDevices = new HashSet<UsbDevice>();
        for (UsbDevice device : usbManager.getDeviceList().values()) {
            int count = device.getInterfaceCount();
            int i = 0;
            while (i < count) {
                UsbInterface intf = device.getInterface(i);
                if (intf.getInterfaceClass() == 7 && intf.getInterfaceSubclass() == 1 && intf.getInterfaceProtocol() == 2) {
                    usbDevices.add(device);
                }
                ++i;
            }
        }
        if (usbDevices.size() > 0) {
            this.mHandler.obtainMessage(10, usbDevices).sendToTarget();
        } else {
            usbDevices = null;
            this.mHandler.obtainMessage(10, null).sendToTarget();
        }
    }

    public void findNetworkPrinters(int timeout) {
        if (this.mBroadcastThread != null) {
            this.mBroadcastThread.interrupt();
            this.mBroadcastThread = null;
        }
        this.mBroadcastThread = new BroadcastThread(this.mContext, this.mHandler, timeout);
        this.mBroadcastThread.start();
    }

    /*
     * Exception decompiling
     */
    public String getMacAddress() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write(byte[] out) {
        if (D) {
            Log.d((String)TAG, (String)("[" + out.length + "] write("));
            String hexString = Utility.toHexString(out);
            int i = 0;
            while (i < hexString.length()) {
                Log.d((String)TAG, (String)hexString.substring(i, i + 4096 < hexString.length() ? i + 4096 : hexString.length()));
                i += 4096;
            }
            Log.d((String)TAG, (String)")");
        }
        if (out != null) {
            switch (this.mConnectivity) {
                case CONNECT_BLUETOOTH: {
                    this.mBluetoothService.write(out);
                    break;
                }
                case CONNECT_NETWORK: {
                    this.mNetworkService.write(out);
                    break;
                }
                case CONNECT_USB: {
                    this.mUsbService.write(out);
                    break;
                }
            }
        }
    }

    private static enum Connectivity {
        CONNECT_NONE,
        CONNECT_BLUETOOTH,
        CONNECT_NETWORK,
        CONNECT_USB;

    }
}

