/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.connectivity;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.metapace.thermalprinter.MetapacePrinter;
import com.metapace.thermalprinter.utility.Utility;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class BroadcastThread
extends Thread {
    private static final String TAG = BroadcastThread.class.getSimpleName();
    private static final boolean D = MetapacePrinter.D;
    private static final int WLAN_LOCAL_PORT = 9000;
    private static final int WLAN_REMOTE_PORT = 3337;
    private static final String WLAN_SEARCH_REQUEST = "__[I_F]__[PRT_REG]";
    private static final String WLAN_SEARCH_RESPONSE = "__[I_F]__[REG_RSP]";
    private static final int LAN_LOCAL_PORT = 48780;
    private static final int LAN_REMOTE_PORT = 48781;
    private static final String LAN_SEARCH_REQUEST = "FIND";
    private static final String LAN_SEARCH_RESPONSE = "IMIN";
    private Context mContext;
    private final Handler mHandler;
    private final int mTimeout;
    private HashSet<String> mIpAdressSet;
    private DatagramSocketThread mLanDatagramSocketThread;
    private DatagramSocketThread mWlanDatagramSocketThread;
    private WifiManager.MulticastLock mMulticastLock;
    private final CountDownLatch mCountDownLatch = new CountDownLatch(1);

    public BroadcastThread(Context context, Handler handler, int timeout) {
        this.mContext = context;
        this.mHandler = handler;
        this.mTimeout = timeout;
        this.mIpAdressSet = new HashSet();
    }

    @Override
    public void run() {
        if (Build.VERSION.SDK_INT <= 10) {
            WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            this.mMulticastLock = wifiManager.createMulticastLock("MulticastLock");
            this.mMulticastLock.acquire();
        }
        this.mWlanDatagramSocketThread = new DatagramSocketThread((WifiManager)this.mContext.getSystemService("wifi"), true);
        this.mLanDatagramSocketThread = new DatagramSocketThread((WifiManager)this.mContext.getSystemService("wifi"), false);
        this.mLanDatagramSocketThread.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BroadcastThread.this.mCountDownLatch.await(BroadcastThread.this.mTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ((BroadcastThread)BroadcastThread.this).mWlanDatagramSocketThread.mStop = true;
                ((BroadcastThread)BroadcastThread.this).mLanDatagramSocketThread.mStop = true;
                BroadcastThread.this.mWlanDatagramSocketThread.interrupt();
                BroadcastThread.this.mWlanDatagramSocketThread = null;
                BroadcastThread.this.mLanDatagramSocketThread.interrupt();
                BroadcastThread.this.mLanDatagramSocketThread = null;
                if (BroadcastThread.this.mIpAdressSet.size() == 0) {
                    BroadcastThread.this.mIpAdressSet = null;
                }
                if (Build.VERSION.SDK_INT <= 10) {
                    BroadcastThread.this.mMulticastLock.release();
                }
                BroadcastThread.this.mHandler.obtainMessage(12, (Object)BroadcastThread.this.mIpAdressSet).sendToTarget();
            }
        }).start();
    }

    private class DatagramSocketThread
    extends Thread {
        final int mLocalPort;
        final int mRemotePort;
        final String mSearchRequest;
        final WifiManager mWifi;
        boolean mStop;

        DatagramSocketThread(WifiManager wifi, boolean mConnectWlan) {
            if (mConnectWlan) {
                this.mLocalPort = 9000;
                this.mRemotePort = 3337;
                this.mSearchRequest = BroadcastThread.WLAN_SEARCH_REQUEST;
                this.setName("WLAN search thread");
            } else {
                this.mLocalPort = 48780;
                this.mRemotePort = 48781;
                this.mSearchRequest = BroadcastThread.LAN_SEARCH_REQUEST;
                this.setName("LAN search thread");
            }
            if (D) {
                Log.i((String)TAG, (String)(String.valueOf(this.getName()) + " begins"));
            }
            this.mWifi = wifi;
        }

        @Override
        public void run() {
            DatagramSocket socket;
            block7: {
                socket = null;
                try {
                    socket = new DatagramSocket(this.mLocalPort);
                    socket.setBroadcast(true);
                    socket.setSoTimeout(BroadcastThread.this.mTimeout);
                }
                catch (SocketException e) {
                    e.printStackTrace();
                    if (D) {
                        Log.e((String)TAG, (String)"Could not send discovery request", (Throwable)e);
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    return;
                }
                try {
                    this.sendDiscoveryRequest(socket);
                    this.listenForResponses(socket);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (!D) break block7;
                    Log.e((String)TAG, (String)"Could not send discovery request", (Throwable)e);
                }
            }
            if (socket != null) {
                socket.close();
            }
        }

        private void sendDiscoveryRequest(final DatagramSocket socket) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!DatagramSocketThread.this.mStop) {
                        if (D) {
                            Log.d((String)TAG, (String)("Sending data " + DatagramSocketThread.this.mSearchRequest));
                        }
                        try {
                            DatagramPacket packet = new DatagramPacket(DatagramSocketThread.this.mSearchRequest.getBytes(), DatagramSocketThread.this.mSearchRequest.getBytes().length, DatagramSocketThread.this.getBroadcastAddress(), DatagramSocketThread.this.mRemotePort);
                            socket.send(packet);
                            packet = new DatagramPacket(DatagramSocketThread.this.mSearchRequest.getBytes(), DatagramSocketThread.this.mSearchRequest.getBytes().length, InetAddress.getByName("255.255.255.255"), DatagramSocketThread.this.mRemotePort);
                            socket.send(packet);
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }

        private InetAddress getBroadcastAddress() throws IOException {
            DhcpInfo dhcp = this.mWifi.getDhcpInfo();
            if (dhcp == null) {
                if (D) {
                    Log.d((String)TAG, (String)"Could not get dhcp info");
                }
                return null;
            }
            int broadcast = dhcp.ipAddress & dhcp.netmask | ~dhcp.netmask;
            byte[] quads = new byte[4];
            int k = 0;
            while (k < 4) {
                quads[k] = (byte)(broadcast >> k * 8 & 0xFF);
                ++k;
            }
            return InetAddress.getByAddress(quads);
        }

        private void listenForResponses(DatagramSocket socket) throws IOException {
            long start = System.currentTimeMillis();
            byte[] buf = new byte[1024];
            try {
                try {
                    while (!this.mStop) {
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        socket.receive(packet);
                        if (D) {
                            String s = new String(packet.getData(), 0, packet.getLength());
                            Log.d((String)TAG, (String)("Packet received after " + (System.currentTimeMillis() - start) + " " + s));
                            Log.d((String)TAG, (String)Utility.toHexString(packet.getData(), 0, packet.getLength()));
                        }
                        this.parseResponse(Utility.copyOfRange(packet.getData(), 0, packet.getLength()), ((InetSocketAddress)packet.getSocketAddress()).getAddress());
                    }
                }
                catch (SocketTimeoutException e) {
                    e.printStackTrace();
                    if (D) {
                        Log.d((String)TAG, (String)"Receive timed out");
                    }
                    if (D) {
                        Log.i((String)TAG, (String)"CountDownLatch.countDown()");
                    }
                    BroadcastThread.this.mCountDownLatch.countDown();
                }
            }
            finally {
                if (D) {
                    Log.i((String)TAG, (String)"CountDownLatch.countDown()");
                }
                BroadcastThread.this.mCountDownLatch.countDown();
            }
        }

        private void parseResponse(byte[] data, InetAddress address) throws IOException {
            String response = new String(data);
            if (D) {
                Log.d((String)TAG, (String)("Receive \"" + response + "\" from " + address));
            }
            if (response.startsWith(BroadcastThread.WLAN_SEARCH_RESPONSE)) {
                StringBuffer buffer = new StringBuffer();
                int i = 24;
                while (i < 28) {
                    buffer.append(data[i] & 0xFF);
                    if (i < 27) {
                        buffer.append('.');
                    }
                    ++i;
                }
                BroadcastThread.this.mIpAdressSet.add(buffer.toString());
            } else if (response.startsWith(BroadcastThread.LAN_SEARCH_RESPONSE)) {
                StringBuffer buffer = new StringBuffer();
                int i = 10;
                while (i < 14) {
                    buffer.append(data[i] & 0xFF);
                    if (i < 13) {
                        buffer.append('.');
                    }
                    ++i;
                }
                BroadcastThread.this.mIpAdressSet.add(buffer.toString());
            }
        }
    }
}

