/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.utility;

import android.os.Environment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FileLog {
    private static final String PATH = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/MetapacePrinterLog.txt";

    public static int println(String tag, String msg) {
        if (msg == null || msg.length() == 0) {
            return -1;
        }
        if (Environment.getExternalStorageState().equals("mounted")) {
            File file = new File(PATH);
            if (file.exists()) {
                if (FileLog.writeFile(file, tag, msg)) {
                    return msg.length();
                }
                return -1;
            }
            boolean isCreated = false;
            try {
                isCreated = file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
            if (isCreated) {
                if (FileLog.writeFile(file, tag, msg)) {
                    return msg.length();
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }

    private static byte[] getLog(String tag, String msg) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:mm:ss.SSSZ", Locale.getDefault());
        StringBuffer buffer = new StringBuffer(sdf.format(new Date(System.currentTimeMillis())));
        buffer.append(": ");
        buffer.append(tag);
        buffer.append("(");
        buffer.append(Thread.currentThread().getStackTrace()[2].getLineNumber());
        buffer.append("): ");
        buffer.append(msg);
        buffer.append("\n");
        return buffer.toString().getBytes();
    }

    private static boolean writeFile(File file, String tag, String msg) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            fos.write(FileLog.getLog(tag, msg));
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fos.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void createBinaryFile(byte[] buffer) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        String path = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/" + sdf.format(new Date(System.currentTimeMillis())) + ".bin";
        File file = new File(path);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            fos.write(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fos.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return;
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

