/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.service;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.metapace.thermalprinter.MetapacePrinter;
import com.metapace.thermalprinter.connectivity.ConnectivityManager;
import com.metapace.thermalprinter.service.PrinterHandler;
import com.metapace.thermalprinter.utility.Command;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class ServiceManager {
    public static final String TAG = "ServiceManager";
    public static final boolean D = MetapacePrinter.D;
    private ConnectivityManager mConnectivityManager;
    private PrinterHandler mPrinterHandler;
    private int mCodePage = -1;
    static final int MODEL_T_3II = 8432;
    static final int MODEL_T_4 = 844;
    private static final String T_3II_NAME = "T-3II";
    private static final String T_4_NAME = "T-4";
    private int mPrinterModel;
    private Handler mApplicationHandler;
    private final int mPrinterObjectHashCode;
    static final int MAX_WIDTH_2INCH = 384;
    static final int MAX_WIDTH_3INCH = 512;
    static final int MAX_WIDTH_3INCH_203DPI = 576;
    static final int MAX_WIDTH_4INCH = 832;
    static final int MAX_WIDTH_400DOT = 400;

    public ServiceManager(int printerObjectHashCode, Context context, Handler applicationHandler, Looper looper) {
        this.mApplicationHandler = applicationHandler;
        this.mPrinterObjectHashCode = printerObjectHashCode;
        this.mPrinterHandler = looper == null ? new PrinterHandler(this, this.mApplicationHandler) : new PrinterHandler(this, this.mApplicationHandler, looper);
        this.mConnectivityManager = new ConnectivityManager(context, this.mPrinterHandler);
    }

    int getPrinterObjectHashCode() {
        return this.mPrinterObjectHashCode;
    }

    public void connect(String address, boolean secure) {
        this.mConnectivityManager.connect(address, secure);
    }

    public void connect(String host, int port, int timeout) {
        this.mConnectivityManager.connect(host, port, timeout);
    }

    public void connect() {
        this.mConnectivityManager.connect();
    }

    public void findUsbPrinters() {
        this.mConnectivityManager.findUsbPrinters();
    }

    public void connect(UsbDevice device) {
        this.mConnectivityManager.connect(device);
    }

    public void findNetworkPrinters(int timeout) {
        this.mConnectivityManager.findNetworkPrinters(timeout);
    }

    public String getMacAddress() {
        return this.mConnectivityManager.getMacAddress();
    }

    public void disconnect() {
        this.mCodePage = -1;
        this.mPrinterHandler.initialize();
        this.mConnectivityManager.disconnect();
    }

    public void findBluetoothPrinters() {
        this.mConnectivityManager.findBluetoothPrinters();
    }

    public int getPrinterModel() {
        return this.mPrinterModel;
    }

    boolean setPrinterModel(String modelName) {
        if (modelName.indexOf(T_3II_NAME) >= 0) {
            this.mPrinterModel = 8432;
            if (D) {
                Log.d((String)TAG, (String)T_3II_NAME);
            }
            return true;
        }
        if (modelName.indexOf(T_4_NAME) >= 0) {
            this.mPrinterModel = 844;
            if (D) {
                Log.d((String)TAG, (String)T_4_NAME);
            }
            return true;
        }
        return false;
    }

    public int getMaxWidth() {
        switch (this.mPrinterModel) {
            case 8432: {
                return 512;
            }
            case 844: {
                return 384;
            }
        }
        return 512;
    }

    public int getCodePage() {
        if (D) {
            Log.d((String)TAG, (String)("getCodePage(): " + this.mCodePage));
        }
        return this.mCodePage;
    }

    public void setCodePage(int codePage) {
        if (D) {
            Log.d((String)TAG, (String)("setCodePage(" + this.mCodePage));
        }
        this.mCodePage = codePage;
    }

    public void executeCommand(byte[] out, boolean getResponse) {
        if (out != null) {
            if (Arrays.equals(out, Command.INITIALIZATION)) {
                this.mPrinterHandler.setCurrentProcess(0);
            }
            this.mConnectivityManager.write(out);
            if (getResponse) {
                this.mPrinterHandler.setCurrentProcess(1);
                this.mConnectivityManager.write(Command.PRINTER_ID_MANUFACTURER);
            }
        }
    }

    public void executeCommand(int process, byte[] out) {
        switch (process) {
            case 19: {
                this.mPrinterHandler.setCurrentProcess(process);
                this.mConnectivityManager.write(out);
                this.mConnectivityManager.write(Command.PRINTER_ID_MANUFACTURER);
                break;
            }
            case 20: {
                this.mPrinterHandler.setCurrentProcess(process);
                this.mConnectivityManager.write(out);
                this.mConnectivityManager.write(Command.PRINTER_ID_MANUFACTURER);
                break;
            }
            case 9: {
                this.mPrinterHandler.setCurrentProcess(process);
                this.mConnectivityManager.write(out);
                break;
            }
            case 21: {
                String name = new String(out);
                if (!name.endsWith("bin") && !name.endsWith("fls")) break;
                File file = new File(name);
                FileInputStream is = null;
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    this.mApplicationHandler.obtainMessage(13).sendToTarget();
                    break;
                }
                int length = 0;
                try {
                    length = ((InputStream)is).available();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                byte[] buffer = new byte[length];
                try {
                    try {
                        ((InputStream)is).read(buffer);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break;
                    }
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.mConnectivityManager.write(buffer);
                this.mPrinterHandler.setCurrentProcess(21);
                break;
            }
            case 22: {
                this.mPrinterHandler.setCurrentProcess(process);
                this.mConnectivityManager.write(out);
            }
        }
    }

    public void executeCommand(int process, int param) {
        switch (process) {
            case 3: {
                this.mPrinterHandler.setCurrentProcess(process);
                this.mConnectivityManager.write(Command.REAL_TIME_OFF_LINE_STATUS);
                break;
            }
            case 4: {
                this.mPrinterHandler.setCurrentProcess(process);
                this.mConnectivityManager.write(Command.REAL_TIME_PAPER_ROLL_SENSOR_STATUS);
                break;
            }
            case 5: {
                int capacity = Command.PRINTER_ID_MODEL_ID.length;
                ByteBuffer buffer = ByteBuffer.allocate(capacity);
                switch (param) {
                    case 65: {
                        buffer = ByteBuffer.wrap(Command.PRINTER_ID_FIRMWARE_VERSION);
                        break;
                    }
                    case 66: {
                        buffer = ByteBuffer.wrap(Command.PRINTER_ID_MANUFACTURER);
                        break;
                    }
                    case 67: {
                        buffer = ByteBuffer.wrap(Command.PRINTER_ID_PRINTER_MODEL);
                        break;
                    }
                    case 69: {
                        buffer = ByteBuffer.wrap(Command.PRINTER_ID_CODE_PAGE);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.mPrinterHandler.setCurrentProcess(process);
                this.mConnectivityManager.write(buffer.array());
                break;
            }
            case 10: {
                this.mCodePage = param;
                int capacity = Command.CHARACTER_CODE_PAGE.length + 1;
                ByteBuffer buffer = ByteBuffer.allocate(capacity);
                buffer.put(Command.CHARACTER_CODE_PAGE);
                buffer.put((byte)this.mCodePage);
                this.mConnectivityManager.write(buffer.array());
                break;
            }
            case 18: {
                this.mPrinterHandler.setCurrentProcess(process);
                this.mConnectivityManager.write(Command.NV_IMAGE_KEY_CODE_LIST);
                break;
            }
            case 32: {
                byte b = 0;
                switch (this.mPrinterModel) {
                    case 8432: {
                        b = 7;
                        break;
                    }
                    case 844: {
                        b = 56;
                        break;
                    }
                }
                if (b <= 0) break;
                int capacity = Command.DRAWER_CONNECTOR_PIN2.length + 1;
                ByteBuffer buffer = ByteBuffer.allocate(capacity);
                if (param == 0) {
                    buffer.put(Command.DRAWER_CONNECTOR_PIN2);
                } else {
                    buffer.put(Command.DRAWER_CONNECTOR_PIN5);
                }
                buffer.put(b);
                this.mConnectivityManager.write(buffer.array());
            }
        }
    }
}

