/*
 * Decompiled with CFR 0.152.
 */
package com.metapace.thermalprinter.connectivity;

import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.StrictMode;
import android.util.Log;
import com.metapace.thermalprinter.connectivity.ConnectivityService;
import com.metapace.thermalprinter.utility.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public final class NetworkService
extends ConnectivityService {
    private static final String TAG = NetworkService.class.getSimpleName();

    NetworkService(Handler handler) {
        super(handler);
    }

    synchronized void connect(String host, int port, int timeout) {
        if (D) {
            Log.d((String)TAG, (String)("connect to: " + host));
        }
        if (D) {
            Log.d((String)TAG, (String)("Build.VERSION.SDK_INT : " + Build.VERSION.SDK_INT));
        }
        int ANDROID_NOUGAT = 24;
        if (Build.VERSION.SDK_INT >= 24) {
            StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(host, port, timeout);
        this.mConnectThread.setName("NetworkService.ConnectThread");
        this.mConnectThread.start();
        this.setState(1);
    }

    synchronized void connected(Socket socket) {
        if (D) {
            Log.d((String)TAG, (String)("connected: " + socket));
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.setName("NetworkService.ConnectedThread");
        this.mConnectedThread.start();
        Message msg = this.mHandler.obtainMessage(4);
        Bundle bundle = new Bundle();
        bundle.putString("device_name", socket.getInetAddress().toString());
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.setState(2);
    }

    private class ConnectThread
    extends ConnectivityService.ConnectThread {
        private final Socket mmSocket;
        private final String mmHost;
        private final int mmPort;
        private int mmTimeout;

        ConnectThread(String host, int port, int timeout) {
            super(NetworkService.this);
            this.mmHost = host;
            this.mmPort = port;
            this.mmTimeout = timeout;
            this.mmSocket = new Socket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (D) {
                Log.i((String)TAG, (String)"BEGIN mConnectThread");
            }
            this.setName("ConnectThread" + this.mmHost);
            try {
                InetSocketAddress remoteAddr = new InetSocketAddress(this.mmHost, this.mmPort);
                this.mmSocket.connect(remoteAddr, this.mmTimeout);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    this.mmSocket.close();
                }
                catch (IOException e2) {
                    Log.e((String)TAG, (String)("unable to close() " + this.mmSocket.getInetAddress() + " socket during connection failure"), (Throwable)e2);
                }
                NetworkService.this.connectionFailed();
                return;
            }
            NetworkService networkService = NetworkService.this;
            synchronized (networkService) {
                NetworkService.this.mConnectThread = null;
            }
            NetworkService.this.connected(this.mmSocket);
        }

        @Override
        void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("close() of connect " + this.mmSocket.getInetAddress() + "socket failed"), (Throwable)e);
            }
        }
    }

    private class ConnectedThread
    extends ConnectivityService.ConnectedThread {
        final Socket mmSocket;
        final InputStream mmInStream;
        final OutputStream mmOutStream;

        ConnectedThread(Socket socket) {
            super(NetworkService.this);
            if (D) {
                Log.d((String)TAG, (String)("create ConnectedThread: " + socket.getInetAddress()));
            }
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"temp sockets not created", (Throwable)e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            if (D) {
                Log.i((String)TAG, (String)"BEGIN mConnectedThread");
            }
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int bytes;
                    if ((bytes = this.mmInStream.read(buffer)) < 0) {
                        NetworkService.this.connectionLost();
                        break;
                    }
                    if (D) {
                        Log.d((String)TAG, (String)("[" + bytes + "] read(" + Utility.toHexString(Utility.copyOfRange(buffer, 0, bytes)) + ")"));
                    }
                    NetworkService.this.mHandler.obtainMessage(2, bytes, -1, (Object)Utility.copyOfRange(buffer, 0, bytes)).sendToTarget();
                }
            }
            catch (IOException e) {
                if (D) {
                    Log.w((String)TAG, (String)"disconnected", (Throwable)e);
                }
                NetworkService.this.connectionLost();
            }
        }

        @Override
        void write(final byte[] buffer) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            ConnectedThread.this.mmOutStream.write(buffer);
                            ((ConnectedThread)ConnectedThread.this).NetworkService.this.mHandler.obtainMessage(3, -1, -1, (Object)buffer).sendToTarget();
                        }
                        catch (IOException e) {
                            if (!D) break block2;
                            Log.e((String)TAG, (String)"Exception during write", (Throwable)e);
                        }
                    }
                }
            }).start();
        }

        @Override
        void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"close() of connect socket failed", (Throwable)e);
            }
        }
    }
}

